/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ColumnPair;
import com.sqlapp.data.db.metadata.ForeignKeyConstraintReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.ForeignKeyConstraint;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005ForeignKeyConstraintReader
extends ForeignKeyConstraintReader {
    public SqlServer2005ForeignKeyConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ForeignKeyConstraint> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List list = CommonUtils.list();
        final TripleKeyMap tCMap = CommonUtils.tripleKeyMap();
        final TripleKeyMap tColMap = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String pk_table_catalog = this.getString(rs, "catalog_name");
                String pk_table_schema = this.getString(rs, "schema_name");
                String pk_table_name = this.getString(rs, "table_name");
                String pk_columnName = this.getString(rs, "column_name");
                String fk_table_schema = this.getString(rs, "referential_schema_name");
                String fk_table_name = this.getString(rs, "referential_table_name");
                String fk_columnName = this.getString(rs, "referential_column_name");
                String fk_name = this.getString(rs, "constraint_name");
                ForeignKeyConstraint c = (ForeignKeyConstraint)tCMap.get((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name);
                FlexList colList = (FlexList)tColMap.get((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name);
                if (c == null) {
                    c = new ForeignKeyConstraint(fk_name);
                    c.setCatalogName(pk_table_catalog);
                    c.setSchemaName(pk_table_schema);
                    c.setTableName(pk_table_name);
                    c.setUpdateRule(CascadeRule.parse((String)this.getString(rs, "update_referential_action_desc")));
                    c.setDeleteRule(CascadeRule.parse((String)this.getString(rs, "delete_referential_action_desc")));
                    c.setEnable(rs.getInt("is_disabled") != 1);
                    c.setCreatedAt(rs.getTimestamp("create_date"));
                    c.setLastAlteredAt(rs.getTimestamp("modify_date"));
                    colList = new FlexList();
                    tCMap.put((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name, (Object)c);
                    tColMap.put((Object)pk_table_catalog, (Object)pk_table_schema, (Object)fk_name, (Object)colList);
                    list.add(c);
                }
                ColumnPair cPair = new ColumnPair();
                cPair.refCatalogName = pk_table_catalog;
                cPair.refSchemaName = fk_table_schema;
                cPair.refTableName = fk_table_name;
                cPair.refColumnName = fk_columnName;
                cPair.columnName = pk_columnName;
                colList.add((Object)cPair);
            }
        });
        this.setForeignKeyConstraintColumns(tColMap, list);
        return list;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("foreignKeyConstraints2005.sql");
    }
}

