/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.stackify.api.AppIdentity;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.collect.SynchronizedEvictingQueue;
import com.stackify.api.common.log.LogTransport;
import com.stackify.api.common.util.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import lombok.NonNull;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCollector {
    private static final Logger log = LoggerFactory.getLogger(LogCollector.class);
    private static final int MAX_BATCH = 100;
    private static final String DEFAULT_PLATFORM = "java";
    private final String logger;
    private final String platform;
    private final EnvironmentDetail envDetail;
    private final AppIdentityService appIdentityService;
    private final Queue<LogMsg> queue = new SynchronizedEvictingQueue<LogMsg>(10000);
    private final RetryPolicy<LogMsgGroup> retryPolicy = new RetryPolicy().withDelay(Duration.ofSeconds(10L)).withMaxRetries(3);

    public LogCollector(@NonNull String platform, @NonNull String logger, @NonNull EnvironmentDetail envDetail, @NonNull AppIdentityService appIdentityService) {
        if (platform == null) {
            throw new NullPointerException("platform is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (envDetail == null) {
            throw new NullPointerException("envDetail is marked non-null but is null");
        }
        if (appIdentityService == null) {
            throw new NullPointerException("appIdentityService is marked non-null but is null");
        }
        this.platform = platform;
        this.logger = logger;
        this.envDetail = envDetail;
        this.appIdentityService = appIdentityService;
    }

    public LogCollector(String logger, EnvironmentDetail envDetail, AppIdentityService appIdentityService) {
        this(DEFAULT_PLATFORM, logger, envDetail, appIdentityService);
    }

    public void addLogMsg(LogMsg logMsg) {
        Preconditions.checkNotNull(logMsg);
        this.queue.offer(logMsg);
    }

    public int flush(LogTransport logTransport) throws Exception {
        int numSent = 0;
        int maxToSend = this.queue.size();
        if (0 < maxToSend) {
            AppIdentity appIdentity = this.appIdentityService.getAppIdentity();
            while (numSent < maxToSend && this.queue.size() > 0) {
                int batchSize = Math.min(maxToSend - numSent, 100);
                ArrayList<LogMsg> batch = new ArrayList<LogMsg>(batchSize);
                for (int i = 0; i < batchSize; ++i) {
                    batch.add(this.queue.remove());
                }
                if (batch.size() <= 0) continue;
                LogMsgGroup group = this.createLogMessageGroup(batch, this.platform, this.logger, this.envDetail, appIdentity);
                this.send(logTransport, group);
                numSent += batchSize;
            }
        }
        return numSent;
    }

    private void send(LogTransport logTransport, LogMsgGroup group) {
        Failsafe.with((Policy[])new RetryPolicy[]{this.retryPolicy}).runAsync(() -> logTransport.send(group));
    }

    private LogMsgGroup createLogMessageGroup(List<LogMsg> batch, String platform, String logger, EnvironmentDetail envDetail, AppIdentity appIdentity) {
        LogMsgGroup.Builder groupBuilder = LogMsgGroup.newBuilder();
        groupBuilder.platform(platform).logger(logger).serverName(envDetail.getDeviceName()).env(envDetail.getConfiguredEnvironmentName()).appName(envDetail.getConfiguredAppName()).appLoc(envDetail.getAppLocation());
        if (appIdentity != null) {
            groupBuilder.cdId(appIdentity.getDeviceId()).cdAppId(appIdentity.getDeviceAppId()).appNameId(appIdentity.getAppNameId()).appEnvId(appIdentity.getAppEnvId()).envId(appIdentity.getEnvId()).env(appIdentity.getEnv());
            if (appIdentity.getAppName() != null && 0 < appIdentity.getAppName().length()) {
                groupBuilder.appName(appIdentity.getAppName());
            }
        }
        groupBuilder.msgs(batch);
        return groupBuilder.build();
    }
}

