/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.socket;

import com.stackify.api.common.socket.ApacheUnixSocket;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.apache.http.HttpHost;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;
import org.newsclub.net.unix.AFUNIXSocketAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class UnixConnectionSocketFactory
implements ConnectionSocketFactory {
    private File socketFile;

    public UnixConnectionSocketFactory(String socketPath) {
        this.socketFile = new File(socketPath);
    }

    public Socket createSocket(HttpContext context) throws IOException {
        return new ApacheUnixSocket();
    }

    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        try {
            socket.connect((SocketAddress)new AFUNIXSocketAddress(this.socketFile), connectTimeout);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectTimeoutException((IOException)e, null, new InetAddress[]{remoteAddress.getAddress()});
        }
        return socket;
    }
}

