/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMobRequest;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.api.StackMobUserBasedRequest;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.net.HttpHelper;
import com.stackmob.sdk.net.HttpVerb;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;

public class StackMob {
    private StackMobSession session;
    private String urlFormat = "api.mob1.stackmob.com";
    private final Object urlFormatLock = new Object();
    protected StackMobRedirectedCallback userRedirectedCallback;
    protected StackMobRedirectedCallback redirectedCallback = new StackMobRedirectedCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redirected(HttpRequest origRequest, HttpResponse response, HttpRequest newRequest) {
            try {
                URI uri = new URI(newRequest.getRequestLine().getUri());
                Object object = StackMob.this.urlFormatLock;
                synchronized (object) {
                    if (!StackMob.this.urlFormat.equalsIgnoreCase(uri.getHost())) {
                        StackMob.this.urlFormat = uri.getHost();
                        StackMob.this.userRedirectedCallback.redirected(origRequest, response, newRequest);
                    }
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    };

    public StackMob(String apiKey, String apiSecret, String userObjectName, String appName, Integer apiVersionNumber) {
        this.setSession(new StackMobSession(apiKey, apiSecret, userObjectName, appName, apiVersionNumber));
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber) {
        this.setSession(new StackMobSession(apiKey, apiSecret, userObjectName, apiVersionNumber));
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber, String urlFormat, StackMobRedirectedCallback redirectedCallback) {
        this(apiKey, apiSecret, userObjectName, apiVersionNumber);
        this.userRedirectedCallback = redirectedCallback;
        this.urlFormat = urlFormat;
    }

    public void login(HashMap<String, Object> params, StackMobCallback callback) {
        new StackMobUserBasedRequest(this.session, "login", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void logout(StackMobCallback callback) {
        new StackMobUserBasedRequest(this.session, "logout", callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void startSession(StackMobCallback callback) {
        new StackMobRequest(this.session, "startsession", HttpVerb.POST, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void endSession(StackMobCallback callback) {
        new StackMobRequest(this.session, "endsession", HttpVerb.POST, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void twitterLogin(String token, String secret, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        new StackMobUserBasedRequest(this.session, "twitterlogin", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void twitterStatusUpdate(String message, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tw_st", message);
        new StackMobUserBasedRequest(this.session, "twitterStatusUpdate", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void registerWithTwitterToken(String token, String secret, String username, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        params.put("username", username);
        new StackMobUserBasedRequest(this.session, "createUserWithTwitter", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void linkUserWithTwitterToken(String token, String secret, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        new StackMobUserBasedRequest(this.session, "linkUserWithTwitter", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void facebookLogin(String token, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fb_at", token);
        new StackMobUserBasedRequest(this.session, "facebookLogin", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void registerWithFacebookToken(String token, String username, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fb_at", token);
        params.put("username", username);
        new StackMobUserBasedRequest(this.session, "createUserWithFacebook", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void linkUserWithFacebookToken(String token, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fb_at", token);
        new StackMobUserBasedRequest(this.session, "linkUserWithFacebook", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void facebookPostMessage(String msg, StackMobCallback callback) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", msg);
        new StackMobUserBasedRequest(this.session, "postFacebookMessage", params, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void getFacebookUserInfo(StackMobCallback callback) {
        this.get("getFacebookUserInfo", callback);
    }

    public void registerForPushWithUser(String username, String registrationID, StackMobCallback callback) {
        RegistrationIDAndUser tokenAndUser = new RegistrationIDAndUser(registrationID, username);
        this.post("/push/register_device_token_universal", tokenAndUser, callback);
    }

    public void get(String path, StackMobCallback callback) {
        new StackMobRequest(this.session, path, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void get(String path, HashMap<String, Object> arguments, StackMobCallback callback) {
        new StackMobRequest(this.session, path, arguments, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void post(String path, Object requestObject, StackMobCallback callback) {
        new StackMobRequest(this.session, path, HttpVerb.POST, requestObject, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void put(String path, String id, Object requestObject, StackMobCallback callback) {
        new StackMobRequest(this.session, path + "/" + id, HttpVerb.PUT, requestObject, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    public void delete(String path, String id, StackMobCallback callback) {
        new StackMobRequest(this.session, path + "/" + id, HttpVerb.DELETE, callback, this.redirectedCallback).setUrlFormat(this.urlFormat).sendRequest();
    }

    private void setSession(StackMobSession session) {
        this.session = session;
        HttpHelper.setVersion(this.session.getApiVersionNumber());
    }

    public StackMobSession getSession() {
        return this.session;
    }

    protected static class RegistrationIDAndUser {
        public String userId;
        public Map<String, String> token = new HashMap<String, String>();

        public RegistrationIDAndUser(String registrationID, String user) {
            this.userId = user;
            this.token.put("token", registrationID);
            this.token.put("type", "android");
        }
    }
}

