/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMobQuery;
import com.stackmob.sdk.api.StackMobQueryWithField;
import com.stackmob.sdk.api.StackMobRequest;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.api.StackMobUserBasedRequest;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.push.StackMobPushToken;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StackMob {
    private StackMobSession session;
    private String apiUrlFormat = "api.mob1.stackmob.com";
    private String pushUrlFormat = "push.mob1.stackmob.com";
    private ExecutorService executor;
    private final Object urlFormatLock = new Object();
    private final CookieManager cookieMgr = new CookieManager();
    protected StackMobRedirectedCallback userRedirectedCallback;
    protected StackMobRedirectedCallback redirectedCallback = new StackMobRedirectedCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redirected(String originalUrl, Map<String, String> redirectHeaders, String redirectBody, String newURL) {
            try {
                URI uri = new URI(newURL);
                Object object = StackMob.this.urlFormatLock;
                synchronized (object) {
                    String host = uri.getHost();
                    if (host.startsWith("push.") && !StackMob.this.pushUrlFormat.equalsIgnoreCase(host)) {
                        StackMob.this.pushUrlFormat = host;
                        StackMob.this.userRedirectedCallback.redirected(originalUrl, redirectHeaders, redirectBody, newURL);
                    } else if (host.startsWith("api.") && !StackMob.this.apiUrlFormat.equalsIgnoreCase(host)) {
                        StackMob.this.apiUrlFormat = host;
                        StackMob.this.userRedirectedCallback.redirected(originalUrl, redirectHeaders, redirectBody, newURL);
                    }
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    };

    private static ExecutorService createNewExecutor() {
        return Executors.newCachedThreadPool();
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, String appName, Integer apiVersionNumber) {
        this.session = new StackMobSession(apiKey, apiSecret, userObjectName, appName, apiVersionNumber);
        CookieHandler.setDefault(this.cookieMgr);
        this.executor = StackMob.createNewExecutor();
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber) {
        this.session = new StackMobSession(apiKey, apiSecret, userObjectName, apiVersionNumber);
        CookieHandler.setDefault(this.cookieMgr);
        this.executor = StackMob.createNewExecutor();
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber, String urlFormat, StackMobRedirectedCallback redirectedCallback) {
        this(apiKey, apiSecret, userObjectName, apiVersionNumber);
        this.userRedirectedCallback = redirectedCallback;
        this.apiUrlFormat = urlFormat;
        this.executor = StackMob.createNewExecutor();
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber, String apiUrlFormat, String pushUrlFormat, StackMobRedirectedCallback redirectedCallback) {
        this(apiKey, apiSecret, userObjectName, apiVersionNumber, apiUrlFormat, redirectedCallback);
        this.pushUrlFormat = pushUrlFormat;
    }

    public void login(Map<String, String> params, StackMobCallback callback) {
        new StackMobUserBasedRequest(this.executor, this.session, "login", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void logout(StackMobCallback callback) {
        new StackMobUserBasedRequest(this.executor, this.session, "logout", callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void startSession(StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, "startsession", HttpVerb.POST, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void twitterLogin(String token, String secret, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        new StackMobUserBasedRequest(this.executor, this.session, "twitterlogin", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void twitterStatusUpdate(String message, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_st", message);
        new StackMobUserBasedRequest(this.executor, this.session, "twitterStatusUpdate", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void registerWithTwitterToken(String token, String secret, String username, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        params.put("username", username);
        new StackMobUserBasedRequest(this.executor, this.session, "createUserWithTwitter", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void linkUserWithTwitterToken(String token, String secret, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        new StackMobUserBasedRequest(this.executor, this.session, "linkUserWithTwitter", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void facebookLogin(String token, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fb_at", token);
        new StackMobUserBasedRequest(this.executor, this.session, "facebookLogin", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void registerWithFacebookToken(String token, String username, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fb_at", token);
        params.put("username", username);
        new StackMobUserBasedRequest(this.executor, this.session, "createUserWithFacebook", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void linkUserWithFacebookToken(String token, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fb_at", token);
        new StackMobUserBasedRequest(this.executor, this.session, "linkUserWithFacebook", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void facebookPostMessage(String msg, StackMobCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", msg);
        new StackMobUserBasedRequest(this.executor, this.session, "postFacebookMessage", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void getFacebookUserInfo(StackMobCallback callback) {
        this.get("getFacebookUserInfo", callback);
    }

    public void pushToTokens(Map<String, String> payload, List<StackMobPushToken> tokens, StackMobCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> payloadMap = new HashMap<String, Map<String, String>>();
        payloadMap.put("kvPairs", payload);
        finalPayload.put("payload", payloadMap);
        finalPayload.put("tokens", tokens);
        this.postPush("push_tokens_universal", finalPayload, callback);
    }

    public void pushToUsers(Map<String, String> payload, List<String> userIds, StackMobCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        finalPayload.put("kvPairs", payload);
        finalPayload.put("userIds", userIds);
        this.postPush("push_users_universal", finalPayload, callback);
    }

    public void registerForPushWithUser(String username, String registrationID, StackMobCallback callback) {
        RegistrationIDAndUser tokenAndUser = new RegistrationIDAndUser(registrationID, username);
        this.postPush("register_device_token_universal", tokenAndUser, callback);
    }

    public void getTokensForUsers(List<String> usernames, StackMobCallback callback) {
        StringBuilder userIds = new StringBuilder();
        boolean first = true;
        for (String username : usernames) {
            if (!first) {
                userIds.append(",");
            }
            first = false;
            userIds.append(username);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userIds", userIds.toString());
        this.getPush("get_tokens_for_users_universal", params, callback);
    }

    public void broadcastPushNotification(Map<String, String> payload, StackMobCallback callback) {
        HashMap<String, Map<String, String>> finalPayload = new HashMap<String, Map<String, String>>();
        finalPayload.put("kvPairs", payload);
        this.postPush("push_broadcast", finalPayload, callback);
    }

    private void getExpiredPushTokens(Boolean clear, StackMobCallback callback) {
        HashMap<String, Boolean> finalPayload = new HashMap<String, Boolean>();
        finalPayload.put("clear", clear);
        this.postPush("get_expired_tokens_universal", finalPayload, callback);
    }

    public void getAndClearExpiredPushTokens(StackMobCallback callback) {
        this.getExpiredPushTokens(true, callback);
    }

    public void getExpiredPushTokens(StackMobCallback callback) {
        this.getExpiredPushTokens(false, callback);
    }

    public void removePushToken(String tokenString, StackMobPushToken.TokenType tokenType, StackMobCallback callback) {
        HashMap<String, String> finalPayload = new HashMap<String, String>();
        finalPayload.put("token", tokenString);
        finalPayload.put("type", tokenType.toString());
        this.postPush("remove_push_token_universal", finalPayload, callback);
    }

    public void get(String path, StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, path, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void get(String path, Map<String, String> arguments, StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, path, arguments, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void get(StackMobQuery query, StackMobCallback callback) {
        this.get("/" + query.getObjectName(), query.getArguments(), callback);
    }

    public void get(StackMobQueryWithField query, StackMobCallback callback) {
        this.get(query.getQuery(), callback);
    }

    private void getPush(String path, Map<String, String> arguments, StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, path, HttpVerb.GET, arguments, callback, this.redirectedCallback).setUrlFormat(this.pushUrlFormat).sendRequest();
    }

    public void post(String path, Object requestObject, StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, path, HttpVerb.POST, requestObject, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    private void postPush(String path, Object requestObject, StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, path, HttpVerb.POST, requestObject, callback, this.redirectedCallback).setUrlFormat(this.pushUrlFormat).sendRequest();
    }

    public void put(String path, String id, Object requestObject, StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, path + "/" + id, HttpVerb.PUT, requestObject, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public void delete(String path, String id, StackMobCallback callback) {
        new StackMobRequest(this.executor, this.session, path + "/" + id, HttpVerb.DELETE, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobSession getSession() {
        return this.session;
    }

    protected static class RegistrationIDAndUser {
        public String userId;
        public Map<String, String> token = new HashMap<String, String>();

        public RegistrationIDAndUser(String registrationID, String user) {
            this.userId = user;
            this.token.put("token", registrationID);
            this.token.put("type", "android");
        }
    }
}

