/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.scribe.model.Response;

public class StackMobCookieStore {
    protected static final String SetCookieHeaderKey = "Set-Cookie";
    protected static final DateFormat cookieDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");
    protected static final String EXPIRES = "Expires";
    protected final ConcurrentHashMap<String, Map.Entry<String, Date>> cookies = new ConcurrentHashMap();

    public void storeCookies(Response resp) {
        this.storeCookie((String)resp.getHeaders().get(SetCookieHeaderKey));
    }

    protected void storeCookie(String cookieString) {
        this.addToCookieMap(cookieString);
    }

    protected void addToCookieMap(String cookieString) {
        if (cookieString != null) {
            String[] valSplit = cookieString.split(";");
            if (valSplit.length == 1) {
                String[] cookieSplit = cookieString.split("=");
                if (cookieSplit.length == 2) {
                    this.storeCookie(valSplit[0], valSplit[1], null);
                }
            } else if (valSplit.length == 2) {
                String[] cookieSplit = valSplit[0].split("=");
                String[] expiresSplit = valSplit[1].split("=");
                Date expires = null;
                if (expiresSplit.length == 2 && cookieSplit.length == 2) {
                    if (expiresSplit[0].equals(EXPIRES)) {
                        try {
                            expires = cookieDateFormat.parse(expiresSplit[1]);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    this.storeCookie(cookieSplit[0], cookieSplit[1], expires);
                }
            }
        }
    }

    protected void storeCookie(String key, String value, Date expiry) {
        this.cookies.put(key, new AbstractMap.SimpleEntry<String, Date>(value, expiry));
    }

    private boolean isUnexpired(Map.Entry<String, Date> values) {
        Date expires = values.getValue();
        return expires == null || new Date().compareTo(expires) == 1;
    }

    public void clear() {
        this.cookies.clear();
    }

    public String cookieHeader() {
        StringBuilder cookieBuilder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Map.Entry<String, Date>> c : this.cookies.entrySet()) {
            if (!first) {
                cookieBuilder.append("; ");
            }
            first = false;
            if (!this.isUnexpired(c.getValue())) continue;
            cookieBuilder.append(c.getKey()).append("=").append(c.getValue().getKey());
        }
        return cookieBuilder.toString();
    }
}

