/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMobQueryWithField;
import com.stackmob.sdk.util.GeoPoint;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StackMobQuery {
    private String objectName;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> args = new HashMap<String, String>();
    private static final String RangeHeader = "Range";
    private static final String ExpandHeader = "X-StackMob-Expand";
    private static final String OrderByHeader = "X-StackMob-OrderBy";
    private static final String SelectHeader = "X-StackMob-Select";

    public StackMobQuery(String objectName) {
        this.objectName = objectName;
    }

    public static StackMobQuery objects(String objectName) {
        return new StackMobQuery(objectName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getArguments() {
        return this.args;
    }

    public StackMobQuery add(StackMobQuery other) {
        this.headers.putAll(other.headers);
        this.args.putAll(other.args);
        return this;
    }

    public StackMobQueryWithField field(String field) {
        return new StackMobQueryWithField(field, this);
    }

    public StackMobQuery fieldIsNear(String field, GeoPoint point) {
        return this.putInMap(field, Operator.NEAR, this.join(point.asList()));
    }

    public StackMobQuery fieldIsNearWithinMi(String field, GeoPoint point, Double maxDistanceMi) {
        List<String> arguments = point.asList();
        arguments.add(GeoPoint.miToRadians(maxDistanceMi).toString());
        return this.putInMap(field, Operator.NEAR, this.join(arguments));
    }

    public StackMobQuery fieldIsNearWithinKm(String field, GeoPoint point, Double maxDistanceKm) {
        List<String> arguments = point.asList();
        arguments.add(GeoPoint.kmToRadians(maxDistanceKm).toString());
        return this.putInMap(field, Operator.NEAR, this.join(arguments));
    }

    public StackMobQuery fieldIsWithinRadiusInMi(String field, GeoPoint point, Double radiusInMi) {
        List<String> arguments = point.asList();
        arguments.add(GeoPoint.miToRadians(radiusInMi).toString());
        return this.putInMap(field, Operator.WITHIN, this.join(arguments));
    }

    public StackMobQuery fieldIsWithinRadiusInKm(String field, GeoPoint point, Double radiusInKm) {
        List<String> arguments = point.asList();
        arguments.add(GeoPoint.kmToRadians(radiusInKm).toString());
        return this.putInMap(field, Operator.WITHIN, this.join(arguments));
    }

    public StackMobQuery fieldIsWithinBox(String field, GeoPoint lowerLeft, GeoPoint upperRight) {
        List<String> arguments = lowerLeft.asList();
        arguments.addAll(upperRight.asList());
        return this.putInMap(field, Operator.WITHIN, this.join(arguments));
    }

    public StackMobQuery fieldIsIn(String field, List<String> values) {
        return this.putInMap(field, Operator.IN, this.join(values));
    }

    public StackMobQuery fieldIsLessThan(String field, String val) {
        return this.putInMap(field, Operator.LT, val);
    }

    public StackMobQuery fieldIslessThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.LTE, val);
    }

    public StackMobQuery fieldIsGreaterThan(String field, String val) {
        return this.putInMap(field, Operator.GT, val);
    }

    public StackMobQuery fieldIsGreaterThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.GTE, val);
    }

    public StackMobQuery fieldIsEqualTo(String field, String val) {
        this.args.put(field, val);
        return this;
    }

    public StackMobQuery fieldIsOrderedBy(String field, Ordering ordering) {
        String buf = this.headers.get(OrderByHeader);
        buf = buf != null ? buf + "," : "";
        buf = buf + field + ":" + ordering.toString();
        this.headers.put(OrderByHeader, buf);
        return this;
    }

    public StackMobQuery expandDepthIs(Integer i) {
        this.headers.put(ExpandHeader, i.toString());
        return this;
    }

    public StackMobQuery isInRange(Integer start, Integer end) {
        this.headers.put(RangeHeader, "objects=" + start.toString() + "-" + end.toString());
        return this;
    }

    public StackMobQuery isInRange(Integer start) {
        this.headers.put(RangeHeader, "objects=" + start.toString() + "-");
        return this;
    }

    public StackMobQuery select(List<String> fields) {
        this.headers.put(SelectHeader, this.join(fields));
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, String value) {
        this.args.put(field + operator.getOperatorForURL(), value);
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, int value) {
        this.putInMap(field, operator, Integer.toString(value));
        return this;
    }

    private String join(List<String> values) {
        return this.join(values, ",");
    }

    private String join(List<String> values, String separator) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : values) {
            if (!first) {
                builder.append(separator);
            }
            first = false;
            builder.append(val);
        }
        return builder.toString();
    }

    public static enum Operator {
        LT("lt"),
        GT("gt"),
        LTE("lte"),
        GTE("gte"),
        IN("in"),
        NEAR("near"),
        WITHIN("within");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String getOperatorForURL() {
            return "[" + this.operator + "]";
        }
    }

    public static enum Ordering {
        DESCENDING("desc"),
        ASCENDING("asc");

        private String name;

        private Ordering(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

