/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.stackmob.sdk.api.StackMobConfiguration;
import com.stackmob.sdk.api.StackMobLogger;
import com.stackmob.sdk.api.StackMobQuery;
import com.stackmob.sdk.api.StackMobQueryWithField;
import com.stackmob.sdk.api.StackMobRequest;
import com.stackmob.sdk.api.StackMobRequestSendResult;
import com.stackmob.sdk.api.StackMobRequestWithPayload;
import com.stackmob.sdk.api.StackMobRequestWithoutPayload;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.api.StackMobUserBasedRequest;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.net.HttpVerb;
import com.stackmob.sdk.net.HttpVerbWithPayload;
import com.stackmob.sdk.net.HttpVerbWithoutPayload;
import com.stackmob.sdk.push.StackMobPushToken;
import com.stackmob.sdk.util.Http;
import com.stackmob.sdk.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StackMob {
    private StackMobSession session;
    private String apiUrlFormat = "api.mob1.stackmob.com";
    private String pushUrlFormat = "push.mob1.stackmob.com";
    private ExecutorService executor;
    private final Object urlFormatLock = new Object();
    private static final String versionKey = "sdk.version";
    private static String userAgentName = "Java Client";
    private static String version = null;
    private static StackMobLogger logger = new StackMobLogger();
    protected StackMobRedirectedCallback userRedirectedCallback;
    protected StackMobRedirectedCallback redirectedCallback = new StackMobRedirectedCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redirected(String originalUrl, Map<String, String> redirectHeaders, String redirectBody, String newURL) {
            try {
                URI uri = new URI(newURL);
                Object object = StackMob.this.urlFormatLock;
                synchronized (object) {
                    String host = uri.getHost();
                    if (host.startsWith("push.") && !StackMob.this.pushUrlFormat.equalsIgnoreCase(host)) {
                        StackMob.this.pushUrlFormat = host;
                        StackMob.this.userRedirectedCallback.redirected(originalUrl, redirectHeaders, redirectBody, newURL);
                    } else if (host.startsWith("api.") && !StackMob.this.apiUrlFormat.equalsIgnoreCase(host)) {
                        StackMob.this.apiUrlFormat = host;
                        StackMob.this.userRedirectedCallback.redirected(originalUrl, redirectHeaders, redirectBody, newURL);
                    }
                }
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
    };
    private static StackMob stackmob;

    public static String getVersion() {
        if (version == null) {
            version = "";
            Properties props = new Properties();
            try {
                props.load(StackMob.class.getClassLoader().getResourceAsStream("build.properties"));
            }
            catch (IOException e) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (props.containsKey(versionKey) && props.get(versionKey) != null && "${version}".equals(version = props.getProperty(versionKey))) {
                version = "dev";
            }
        }
        return version;
    }

    protected static String getUserAgent(String appName) {
        return String.format("StackMob (%s; %s)%s", userAgentName, StackMob.getVersion(), appName == null ? "" : "/" + appName);
    }

    public static void setUserAgentName(String name) {
        userAgentName = name;
    }

    private static ExecutorService createNewExecutor() {
        return Executors.newCachedThreadPool();
    }

    public static void setLogger(StackMobLogger logger) {
        StackMob.logger = logger;
    }

    public static StackMobLogger getLogger() {
        return logger;
    }

    public static synchronized StackMob getStackMob() {
        if (stackmob == null) {
            stackmob = StackMobConfiguration.newStackMob();
        }
        return stackmob;
    }

    public static void setStackMob(StackMob stackmob) {
        StackMob.stackmob = stackmob;
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, String appName, Integer apiVersionNumber) {
        this.session = new StackMobSession(apiKey, apiSecret, userObjectName, appName, apiVersionNumber);
        this.executor = StackMob.createNewExecutor();
        if (stackmob == null) {
            StackMob.setStackMob(this);
        }
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber) {
        this(apiKey, apiSecret, userObjectName, null, apiVersionNumber);
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber, String urlFormat, StackMobRedirectedCallback redirectedCallback) {
        this(apiKey, apiSecret, userObjectName, null, apiVersionNumber, urlFormat, "push.mob1.stackmob.com", redirectedCallback);
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, Integer apiVersionNumber, String apiUrlFormat, String pushUrlFormat, StackMobRedirectedCallback redirectedCallback) {
        this(apiKey, apiSecret, userObjectName, null, apiVersionNumber, apiUrlFormat, pushUrlFormat, redirectedCallback);
    }

    public StackMob(String apiKey, String apiSecret, String userObjectName, String appName, Integer apiVersionNumber, String apiUrlFormat, String pushUrlFormat, StackMobRedirectedCallback redirectedCallback) {
        this(apiKey, apiSecret, userObjectName, appName, apiVersionNumber);
        this.userRedirectedCallback = redirectedCallback;
        this.apiUrlFormat = apiUrlFormat;
        this.pushUrlFormat = pushUrlFormat;
    }

    public StackMob(StackMob other) {
        this.session = other.session;
        this.userRedirectedCallback = other.redirectedCallback;
        this.apiUrlFormat = other.apiUrlFormat;
        this.pushUrlFormat = other.pushUrlFormat;
        this.executor = other.executor;
    }

    public StackMobRequestSendResult login(Map<String, String> params, StackMobRawCallback callback) {
        this.session.setLastUserLoginName(params.get("username"));
        return new StackMobUserBasedRequest(this.executor, this.session, "login", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult logout(StackMobRawCallback callback) {
        return new StackMobUserBasedRequest(this.executor, this.session, "logout", StackMobRequest.EmptyParams, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult startSession(StackMobRawCallback callback) {
        return new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, "startsession", callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult twitterLogin(String token, String secret, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        return new StackMobUserBasedRequest(this.executor, this.session, "twitterlogin", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult twitterStatusUpdate(String message, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_st", message);
        return new StackMobUserBasedRequest(this.executor, this.session, "twitterStatusUpdate", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult registerWithTwitterToken(String token, String secret, String username, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        params.put("username", username);
        return new StackMobUserBasedRequest(this.executor, this.session, "createUserWithTwitter", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult linkUserWithTwitterToken(String token, String secret, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tw_tk", token);
        params.put("tw_ts", secret);
        return new StackMobUserBasedRequest(this.executor, this.session, "linkUserWithTwitter", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult facebookLogin(String token, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fb_at", token);
        return new StackMobUserBasedRequest(this.executor, this.session, "facebookLogin", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult registerWithFacebookToken(String token, String username, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fb_at", token);
        params.put("username", username);
        return new StackMobUserBasedRequest(this.executor, this.session, "createUserWithFacebook", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult linkUserWithFacebookToken(String token, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fb_at", token);
        return new StackMobUserBasedRequest(this.executor, this.session, "linkUserWithFacebook", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult facebookPostMessage(String msg, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", msg);
        return new StackMobUserBasedRequest(this.executor, this.session, "postFacebookMessage", params, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult getFacebookUserInfo(StackMobRawCallback callback) {
        return new StackMobUserBasedRequest(this.executor, this.session, "getFacebookUserInfo", new HashMap<String, String>(), callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult getTwitterUserInfo(StackMobRawCallback callback) {
        return new StackMobUserBasedRequest(this.executor, this.session, "getTwitterUserInfo", new HashMap<String, String>(), callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult pushToTokens(Map<String, String> payload, List<StackMobPushToken> tokens, StackMobRawCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        HashMap<String, Map<String, String>> payloadMap = new HashMap<String, Map<String, String>>();
        payloadMap.put("kvPairs", payload);
        finalPayload.put("payload", payloadMap);
        finalPayload.put("tokens", tokens);
        return this.postPush("push_tokens_universal", finalPayload, callback);
    }

    public StackMobRequestSendResult pushToUsers(Map<String, String> payload, List<String> userIds, StackMobRawCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        finalPayload.put("kvPairs", payload);
        finalPayload.put("userIds", userIds);
        return this.postPush("push_users_universal", finalPayload, callback);
    }

    public StackMobRequestSendResult registerForPushWithUser(String username, String registrationID, StackMobRawCallback callback) {
        RegistrationIDAndUser tokenAndUser = new RegistrationIDAndUser(registrationID, username);
        return this.postPush("register_device_token_universal", tokenAndUser, callback);
    }

    public StackMobRequestSendResult registerForPushWithUser(String username, String registrationID, boolean overwrite, StackMobRawCallback callback) {
        RegistrationIDAndUser tokenAndUser = new RegistrationIDAndUser(registrationID, username, overwrite);
        return this.postPush("register_device_token_universal", tokenAndUser, callback);
    }

    public StackMobRequestSendResult getTokensForUsers(List<String> usernames, StackMobRawCallback callback) {
        StringBuilder userIds = new StringBuilder();
        boolean first = true;
        for (String username : usernames) {
            if (!first) {
                userIds.append(",");
            }
            first = false;
            userIds.append(username);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userIds", userIds.toString());
        return this.getPush("get_tokens_for_users_universal", params, callback);
    }

    public StackMobRequestSendResult getUsersForTokens(List<String> tokens, StackMobRawCallback callback) {
        StringBuilder tokenString = new StringBuilder();
        boolean first = true;
        for (String token : tokens) {
            if (!first) {
                tokenString.append(",");
            }
            first = false;
            tokenString.append(token);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tokens", tokenString.toString());
        return this.getPush("get_users_for_tokens_universal", params, callback);
    }

    public StackMobRequestSendResult broadcastPushNotification(Map<String, String> payload, StackMobRawCallback callback) {
        HashMap<String, Map<String, String>> finalPayload = new HashMap<String, Map<String, String>>();
        finalPayload.put("kvPairs", payload);
        return this.postPush("push_broadcast", finalPayload, callback);
    }

    private StackMobRequestSendResult getExpiredPushTokens(Boolean clear, StackMobRawCallback callback) {
        HashMap<String, Boolean> finalPayload = new HashMap<String, Boolean>();
        finalPayload.put("clear", clear);
        return this.postPush("get_expired_tokens_universal", finalPayload, callback);
    }

    public StackMobRequestSendResult getAndClearExpiredPushTokens(StackMobRawCallback callback) {
        return this.getExpiredPushTokens(true, callback);
    }

    public StackMobRequestSendResult getExpiredPushTokens(StackMobRawCallback callback) {
        return this.getExpiredPushTokens(false, callback);
    }

    public StackMobRequestSendResult removePushToken(String tokenString, StackMobPushToken.TokenType tokenType, StackMobRawCallback callback) {
        HashMap<String, String> finalPayload = new HashMap<String, String>();
        finalPayload.put("token", tokenString);
        finalPayload.put("type", tokenType.toString());
        return this.postPush("remove_token_universal", finalPayload, callback);
    }

    public StackMobRequestSendResult get(String path, StackMobRawCallback callback) {
        return new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, path, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult get(String path, Map<String, String> arguments, Map<String, String> headerMap, StackMobRawCallback callback) {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, String> header : headerMap.entrySet()) {
            headers.add(header);
        }
        return this.get(path, arguments, headers, callback);
    }

    public StackMobRequestSendResult get(String path, Map<String, String> arguments, List<Map.Entry<String, String>> headers, StackMobRawCallback callback) {
        return new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, headers, arguments, path, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult get(String path, Map<String, String> arguments, StackMobRawCallback callback) {
        return this.get(path, arguments, StackMobRequest.EmptyHeaders, callback);
    }

    public StackMobRequestSendResult get(StackMobQuery query, StackMobRawCallback callback) {
        return this.get("/" + query.getObjectName(), query.getArguments(), query.getHeaders(), callback);
    }

    public StackMobRequestSendResult get(StackMobQueryWithField query, StackMobRawCallback callback) {
        return this.get(query.getQuery(), callback);
    }

    public StackMobRequestSendResult getPush(String path, Map<String, String> arguments, StackMobRawCallback callback) {
        return new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.GET, StackMobRequest.EmptyHeaders, arguments, path, callback, this.redirectedCallback).setUrlFormat(this.pushUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult post(String path, Object requestObject, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, requestObject, path, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult post(String path, String body, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, body, path, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult post(String path, String body, List<Map.Entry<String, String>> headers, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, headers, StackMobRequest.EmptyParams, body, path, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public <T> StackMobRequestSendResult postBulk(String path, List<T> requestObjects, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, requestObjects, path, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult postRelated(String path, String primaryId, String relatedField, Object relatedObject, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, relatedObject, String.format("%s/%s/%s", path, primaryId, relatedField), callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public <T> StackMobRequestSendResult postRelatedBulk(String path, String primaryId, String relatedField, List<T> relatedObjects, StackMobRawCallback callback) {
        return this.postRelated(path, primaryId, relatedField, relatedObjects, callback);
    }

    public StackMobRequestSendResult postPush(String path, Object requestObject, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, requestObject, path, callback, this.redirectedCallback).setUrlFormat(this.pushUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult put(String path, String id, Object requestObject, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.PUT, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, requestObject, path + "/" + id, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult put(String path, String id, String body, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.PUT, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, body, path + "/" + id, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult putAndUpdateAtomicCounters(String path, String id, Object requestObject, List<String> counterFields, StackMobRawCallback callback) {
        JsonObject obj = new Gson().toJsonTree(requestObject).getAsJsonObject();
        for (Map.Entry field : new HashSet(obj.entrySet())) {
            if (!counterFields.contains(field.getKey())) continue;
            obj.remove((String)field.getKey());
            obj.add((String)field.getKey() + "[inc]", (JsonElement)field.getValue());
        }
        return this.put(path, id, obj.toString(), callback);
    }

    public StackMobRequestSendResult updateAtomicCounter(String path, String id, String field, int value, StackMobRawCallback callback) {
        JsonObject body = new JsonObject();
        body.add(field + "[inc]", (JsonElement)new JsonPrimitive((Number)value));
        return this.put(path, id, body.toString(), callback);
    }

    public <T> StackMobRequestSendResult putRelated(String path, String primaryId, String relatedField, List<T> relatedIds, StackMobRawCallback callback) {
        return new StackMobRequestWithPayload(this.executor, this.session, HttpVerbWithPayload.PUT, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, relatedIds, String.format("%s/%s/%s", path, primaryId, relatedField), callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult delete(String path, String id, StackMobRawCallback callback) {
        return new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.DELETE, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, path + "/" + id, callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public <T> StackMobRequestSendResult deleteIdsFrom(String path, String primaryId, String field, List<T> idsToDelete, boolean cascadeDeletes, StackMobRawCallback callback) {
        StringBuilder ids = new StringBuilder();
        for (int i = 0; i < idsToDelete.size(); ++i) {
            ids.append(idsToDelete.get(i).toString());
            if (i >= idsToDelete.size() - 1) continue;
            ids.append(",");
        }
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        if (cascadeDeletes) {
            headers.add(new Pair<String, String>("X-StackMob-CascadeDelete", "true"));
        }
        return new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.DELETE, headers, StackMobRequest.EmptyParams, String.format("%s/%s/%s/%s", path, primaryId, field, ids.toString()), callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public <T> StackMobRequestSendResult deleteIdFrom(String path, String primaryId, String field, T idToDelete, boolean cascadeDelete, StackMobRawCallback callback) {
        ArrayList<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
        if (cascadeDelete) {
            headers.add(new Pair<String, String>("X-StackMob-CascadeDelete", "true"));
        }
        return new StackMobRequestWithoutPayload(this.executor, this.session, HttpVerbWithoutPayload.DELETE, headers, StackMobRequest.EmptyParams, String.format("%s/%s/%s/%s", path, primaryId, field, idToDelete), callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult count(String path, StackMobRawCallback callback) {
        return this.count(new StackMobQuery(path), callback);
    }

    public StackMobRequestSendResult count(StackMobQuery query, StackMobRawCallback callback) {
        final StackMobRawCallback userCallback = callback;
        return this.get(query.isInRange(0, 0), new StackMobRawCallback(){

            @Override
            public void done(HttpVerb requestVerb, String requestURL, List<Map.Entry<String, String>> requestHeaders, String requestBody, Integer responseStatusCode, List<Map.Entry<String, String>> responseHeaders, byte[] responseBody) {
                if (Http.isSuccess(responseStatusCode)) {
                    long count = 2.getTotalNumberOfItemsFromContentRange(responseHeaders).intValue();
                    if (count < 0L) {
                        try {
                            count = new JsonParser().parse(new String(responseBody)).getAsJsonArray().size();
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    responseBody = String.valueOf(count).getBytes();
                }
                userCallback.setDone(requestVerb, requestURL, requestHeaders, requestBody, responseStatusCode, responseHeaders, responseBody);
            }
        });
    }

    public StackMobRequestSendResult forgotPassword(String username, StackMobRawCallback callback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        return new StackMobUserBasedRequest(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, params, "forgotPassword", callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public StackMobRequestSendResult resetPassword(String oldPassword, String newPassword, StackMobRawCallback callback) {
        HashMap params = new HashMap();
        HashMap<String, String> oldPW = new HashMap<String, String>();
        oldPW.put("password", oldPassword);
        HashMap<String, String> newPW = new HashMap<String, String>();
        newPW.put("password", newPassword);
        params.put("old", oldPW);
        params.put("new", newPW);
        return new StackMobUserBasedRequest(this.executor, this.session, HttpVerbWithPayload.POST, StackMobRequest.EmptyHeaders, StackMobRequest.EmptyParams, params, "resetPassword", callback, this.redirectedCallback).setUrlFormat(this.apiUrlFormat).sendRequest();
    }

    public String getLoggedInUser() {
        return this.isLoggedIn() ? this.session.getLastUserLoginName() : null;
    }

    public boolean isLoggedIn() {
        Map.Entry<String, Date> sessionCookie = StackMobRequest.getCookieStore().getSessionCookie();
        if (sessionCookie != null) {
            boolean cookieIsStillValid = sessionCookie.getValue() == null || sessionCookie.getValue().before(new Date());
            return cookieIsStillValid && !this.isLoggedOut();
        }
        return false;
    }

    public boolean isUserLoggedIn(String username) {
        return username != null && username.equals(this.getLoggedInUser());
    }

    public boolean isLoggedOut() {
        Map.Entry<String, Date> sessionCookie = StackMobRequest.getCookieStore().getSessionCookie();
        return sessionCookie != null && sessionCookie.getKey().contains(":");
    }

    public StackMobSession getSession() {
        return this.session;
    }

    public void setSession(StackMobSession session) {
        this.session = session;
    }

    public static class RegistrationIDAndUser {
        public String userId;
        public Map<String, String> token = new HashMap<String, String>();
        public Boolean overwrite = null;

        public RegistrationIDAndUser(String registrationID, String user) {
            this(registrationID, user, "android");
        }

        public RegistrationIDAndUser(String registrationID, String user, String platform) {
            this.userId = user;
            this.token.put("token", registrationID);
            this.token.put("type", platform);
        }

        public RegistrationIDAndUser(String registrationID, String user, String platform, boolean overwrite) {
            this(registrationID, user, platform);
            this.overwrite = overwrite;
        }

        public RegistrationIDAndUser(String registrationID, String user, boolean overwrite) {
            this(registrationID, user, "android", overwrite);
        }
    }
}

