/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.model;

import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.callback.StackMobCallback;
import com.stackmob.sdk.callback.StackMobIntermediaryCallback;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.exception.StackMobException;
import com.stackmob.sdk.model.StackMobModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class StackMobUser
extends StackMobModel {
    String password;

    protected StackMobUser(Class<? extends StackMobUser> actualClass, String username, String password) {
        super(actualClass);
        this.setID(username);
        this.password = password;
    }

    public StackMobUser(String username, String password) {
        this(StackMobUser.class, username, password);
    }

    @Override
    public String getSchemaName() {
        return StackMob.getStackMob().getSession().getUserObjectName();
    }

    @Override
    public String getIDFieldName() {
        return "username";
    }

    public String getUsername() {
        return this.getID();
    }

    private Map<String, String> getLoginArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("username", this.getID());
        args.put("password", this.password);
        return args;
    }

    protected void login(Map<String, String> args, StackMobCallback callback) {
        StackMob.getStackMob().login(args, new StackMobIntermediaryCallback(callback){

            @Override
            public void success(String responseBody) {
                StackMobUser.this.password = null;
                try {
                    StackMobUser.this.fillFromJson(responseBody);
                }
                catch (StackMobException e) {
                    StackMob.getLogger().logWarning("Error filling in user model from login" + e, new Object[0]);
                }
                super.success(responseBody);
            }
        });
    }

    public void login(StackMobCallback callback) {
        this.login(this.getLoginArgs(), callback);
    }

    public void loginResettingTemporaryPassword(String newPassword, StackMobCallback callback) {
        Map<String, String> args = this.getLoginArgs();
        args.put("new_password", newPassword);
        this.login(args, callback);
    }

    public void logout(StackMobCallback callback) {
        StackMob.getStackMob().logout(callback);
    }

    public boolean isLoggedIn() {
        return StackMob.getStackMob().isUserLoggedIn(this.getID());
    }

    public void resetPassword(String oldPassword, String newPassword, StackMobCallback callback) {
        StackMob.getStackMob().resetPassword(oldPassword, newPassword, callback);
    }

    public void registerForPush(String registrationID, StackMobRawCallback callback) {
        StackMob.getStackMob().registerForPushWithUser(this.getID(), registrationID, callback);
    }

    public void getPushToken(StackMobRawCallback callback) {
        StackMob.getStackMob().getTokensForUsers(Arrays.asList(this.getID()), callback);
    }
}

