/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.util;

import java.util.ArrayList;
import java.util.List;

public class GeoPoint {
    private static final double EarthRadiusInMi = 3956.6;
    private static final double EarthRadiusInKm = 6367.5;
    private Double lon = Double.NaN;
    private Double lat = Double.NaN;

    public GeoPoint(Double lon, Double lat) {
        this.lon = lon;
        this.lat = lat;
    }

    public Double getLongitude() {
        return this.lon;
    }

    public Double getLatitude() {
        return this.lat;
    }

    public List<String> asList() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getLatitude().toString());
        arguments.add(this.getLongitude().toString());
        return arguments;
    }

    public static Double radiansToMi(double radians) {
        return radians * 3956.6;
    }

    public static Double radiansToKm(double radians) {
        return radians * 6367.5;
    }

    public static Double miToRadians(double mi) {
        return mi / 3956.6;
    }

    public static Double kmToRadians(double km) {
        return km / 6367.5;
    }
}

