/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.api;

import com.stackmob.sdk.api.StackMobGeoPoint;
import com.stackmob.sdk.api.StackMobQueryField;
import com.stackmob.sdk.util.ListHelpers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StackMobQuery {
    private String objectName;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> args = new HashMap<String, String>();
    private static final String RangeHeader = "Range";
    private static final String OrderByHeader = "X-StackMob-OrderBy";

    public StackMobQuery() {
    }

    public StackMobQuery(String objectName) {
        this.objectName = objectName;
    }

    public static StackMobQuery objects(String objectName) {
        return new StackMobQuery(objectName);
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<Map.Entry<String, String>> getArguments() {
        return new ArrayList<Map.Entry<String, String>>(this.args.entrySet());
    }

    public StackMobQuery add(StackMobQuery other) {
        this.headers.putAll(other.headers);
        this.args.putAll(other.args);
        return this;
    }

    public StackMobQuery field(StackMobQueryField field) {
        this.add(field.getQuery());
        return this;
    }

    public StackMobQuery fieldIsNear(String field, StackMobGeoPoint point) {
        return this.putInMap(field, Operator.NEAR, ListHelpers.join(point.asList(), ","));
    }

    public StackMobQuery fieldIsNearWithinMi(String field, StackMobGeoPoint point, Double maxDistanceMi) {
        List<String> arguments = point.asList();
        arguments.add(StackMobGeoPoint.miToRadians(maxDistanceMi).toString());
        return this.putInMap(field, Operator.NEAR, ListHelpers.join(arguments, ","));
    }

    public StackMobQuery fieldIsNearWithinKm(String field, StackMobGeoPoint point, Double maxDistanceKm) {
        List<String> arguments = point.asList();
        arguments.add(StackMobGeoPoint.kmToRadians(maxDistanceKm).toString());
        return this.putInMap(field, Operator.NEAR, ListHelpers.join(arguments, ","));
    }

    public StackMobQuery fieldIsWithinRadiusInMi(String field, StackMobGeoPoint point, Double radiusInMi) {
        List<String> arguments = point.asList();
        arguments.add(StackMobGeoPoint.miToRadians(radiusInMi).toString());
        return this.putInMap(field, Operator.WITHIN, ListHelpers.join(arguments, ","));
    }

    public StackMobQuery fieldIsWithinRadiusInKm(String field, StackMobGeoPoint point, Double radiusInKm) {
        List<String> arguments = point.asList();
        arguments.add(StackMobGeoPoint.kmToRadians(radiusInKm).toString());
        return this.putInMap(field, Operator.WITHIN, ListHelpers.join(arguments, ","));
    }

    public StackMobQuery fieldIsWithinBox(String field, StackMobGeoPoint lowerLeft, StackMobGeoPoint upperRight) {
        List<String> arguments = lowerLeft.asList();
        arguments.addAll(upperRight.asList());
        return this.putInMap(field, Operator.WITHIN, ListHelpers.join(arguments, ","));
    }

    public StackMobQuery fieldIsIn(String field, List<String> values) {
        return this.putInMap(field, Operator.IN, ListHelpers.join(values, ","));
    }

    public StackMobQuery fieldIsNotEqual(String field, String val) {
        return this.putInMap(field, Operator.NE, val);
    }

    public StackMobQuery fieldIsNull(String field) {
        return this.putInMap(field, Operator.NULL, "true");
    }

    public StackMobQuery fieldIsNotNull(String field) {
        return this.putInMap(field, Operator.NULL, "false");
    }

    public StackMobQuery fieldIsLessThan(String field, String val) {
        return this.putInMap(field, Operator.LT, val);
    }

    public StackMobQuery fieldIsLessThan(String field, int val) {
        return this.putInMap(field, Operator.LT, String.valueOf(val));
    }

    public StackMobQuery fieldIslessThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.LTE, val);
    }

    public StackMobQuery fieldIsLessThanOrEqualTo(String field, int val) {
        return this.putInMap(field, Operator.LTE, String.valueOf(val));
    }

    public StackMobQuery fieldIsGreaterThan(String field, String val) {
        return this.putInMap(field, Operator.GT, val);
    }

    public StackMobQuery fieldIsGreaterThan(String field, int val) {
        return this.putInMap(field, Operator.GT, String.valueOf(val));
    }

    public StackMobQuery fieldIsGreaterThanOrEqualTo(String field, String val) {
        return this.putInMap(field, Operator.GTE, val);
    }

    public StackMobQuery fieldIsGreaterThanOrEqualTo(String field, int val) {
        return this.putInMap(field, Operator.GTE, String.valueOf(val));
    }

    public StackMobQuery fieldIsEqualTo(String field, String val) {
        this.args.put(field, val);
        return this;
    }

    public StackMobQuery fieldIsOrderedBy(String field, Ordering ordering) {
        String buf = this.headers.get(OrderByHeader);
        buf = buf != null ? buf + "," : "";
        buf = buf + field + ":" + ordering.toString();
        this.headers.put(OrderByHeader, buf);
        return this;
    }

    public StackMobQuery isInRange(Integer start, Integer end) {
        this.headers.put(RangeHeader, "objects=" + start.toString() + "-" + end.toString());
        return this;
    }

    public StackMobQuery isInRange(Integer start) {
        this.headers.put(RangeHeader, "objects=" + start.toString() + "-");
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, String value) {
        this.args.put(field + operator.getOperatorForURL(), value);
        return this;
    }

    private StackMobQuery putInMap(String field, Operator operator, int value) {
        this.putInMap(field, operator, Integer.toString(value));
        return this;
    }

    static enum Operator {
        LT("lt"),
        GT("gt"),
        LTE("lte"),
        GTE("gte"),
        IN("in"),
        NEAR("near"),
        WITHIN("within"),
        NE("ne"),
        NULL("null");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String getOperatorForURL() {
            return "[" + this.operator + "]";
        }
    }

    public static enum Ordering {
        DESCENDING("desc"),
        ASCENDING("asc");

        private String name;

        private Ordering(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

