/*
 * Decompiled with CFR 0.152.
 */
package com.stackmob.sdk.push;

import com.stackmob.sdk.api.StackMob;
import com.stackmob.sdk.api.StackMobOptions;
import com.stackmob.sdk.api.StackMobSession;
import com.stackmob.sdk.callback.StackMobRawCallback;
import com.stackmob.sdk.callback.StackMobRedirectedCallback;
import com.stackmob.sdk.net.HttpVerbWithPayload;
import com.stackmob.sdk.net.HttpVerbWithoutPayload;
import com.stackmob.sdk.push.StackMobPushToken;
import com.stackmob.sdk.request.StackMobRequest;
import com.stackmob.sdk.request.StackMobRequestWithPayload;
import com.stackmob.sdk.request.StackMobRequestWithoutPayload;
import com.stackmob.sdk.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class StackMobPush {
    public static String DEFAULT_PUSH_HOST = "push.stackmob.com";
    private boolean fake = false;
    private ExecutorService executor;
    private StackMobSession session;
    private String host;
    private StackMobRedirectedCallback redirectedCallback;
    private static StackMobPush push;

    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public static void setPushType(StackMobPushToken.TokenType type) {
        StackMobPushToken.setPushType(type);
    }

    public static StackMobPush getPush() {
        return push;
    }

    public static void setPush(StackMobPush push) {
        StackMobPush.push = push;
    }

    public StackMobPush(int apiVersionNumber, String apiKey, String apiSecret) {
        this(apiVersionNumber, apiKey, apiSecret, DEFAULT_PUSH_HOST, StackMob.DEFAULT_REDIRECTED_CALLBACK);
        new StackMob(StackMob.OAuthVersion.One, apiVersionNumber, apiKey, apiSecret);
    }

    public StackMobPush(int apiVersionNumber, String apiKey, String apiSecret, String host, StackMobRedirectedCallback redirectedCallback) {
        this.executor = Executors.newCachedThreadPool();
        this.session = new StackMobSession(StackMob.OAuthVersion.One, apiVersionNumber, apiKey, apiSecret, StackMob.DEFAULT_USER_SCHEMA_NAME, StackMob.DEFAULT_USER_ID);
        this.host = host;
        this.redirectedCallback = redirectedCallback;
        if (push == null) {
            push = this;
        }
    }

    public StackMobPush(StackMob stackmob) {
        this(stackmob, DEFAULT_PUSH_HOST);
    }

    public StackMobPush(StackMob stackmob, String host) {
        this.executor = stackmob.getExecutor();
        this.session = stackmob.getSession();
        this.host = host;
        this.redirectedCallback = stackmob.getRedirectedCallback();
        if (push == null) {
            push = this;
        }
    }

    private String tokenPath(StackMobPushToken token) {
        return String.format("tokens/%s/%s", token.getTokenType().toString(), token.getToken());
    }

    public void registerForPushWithUser(StackMobPushToken token, String username, StackMobRawCallback callback) {
        this.registerForPushWithUser(token, username, false, callback);
    }

    public void registerForPushWithUser(StackMobPushToken token, String username, boolean overwrite, StackMobRawCallback callback) {
        HashMap<String, String> user = new HashMap<String, String>();
        user.put("user", username);
        HttpVerbWithPayload verb = overwrite ? HttpVerbWithPayload.PUT : HttpVerbWithPayload.POST;
        this.sendWithPayload(verb, this.tokenPath(token), user, callback);
    }

    public void getTokensForUsers(List<String> usernames, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> params = new LinkedList<Map.Entry<String, String>>();
        for (String username : usernames) {
            params.add(new Pair<String, String>("user", username));
        }
        this.sendWithoutPayload(HttpVerbWithoutPayload.GET, "tokens", params, callback);
    }

    public void pushToTokens(Map<String, String> payload, List<StackMobPushToken> tokens, StackMobRawCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        finalPayload.put("payload", payload);
        finalPayload.put("tokens", tokens);
        if (this.fake) {
            finalPayload.put("fake", this.fake);
        }
        this.sendWithPayload(HttpVerbWithPayload.POST, "notifications", finalPayload, callback);
    }

    public void pushToUsers(Map<String, String> payload, List<String> userIds, StackMobRawCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        finalPayload.put("payload", payload);
        finalPayload.put("users", userIds);
        if (this.fake) {
            finalPayload.put("fake", this.fake);
        }
        this.sendWithPayload(HttpVerbWithPayload.POST, "notifications", finalPayload, callback);
    }

    public void broadcastPushNotification(Map<String, String> payload, StackMobRawCallback callback) {
        HashMap<String, Object> finalPayload = new HashMap<String, Object>();
        finalPayload.put("payload", payload);
        if (this.fake) {
            finalPayload.put("fake", this.fake);
        }
        this.sendWithPayload(HttpVerbWithPayload.POST, "notifications", finalPayload, callback);
    }

    public void removePushToken(StackMobPushToken token, StackMobRawCallback callback) {
        LinkedList<Map.Entry<String, String>> args = new LinkedList<Map.Entry<String, String>>();
        this.sendWithoutPayload(HttpVerbWithoutPayload.DELETE, this.tokenPath(token), args, callback);
    }

    private void sendWithPayload(HttpVerbWithPayload verb, String path, Object requestObject, StackMobRawCallback callback) {
        new StackMobRequestWithPayload(this.executor, this.session, StackMob.OAuthVersion.One, verb, StackMobOptions.none(), StackMobRequest.EmptyParams, requestObject, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }

    private void sendWithoutPayload(HttpVerbWithoutPayload verb, String path, List<Map.Entry<String, String>> arguments, StackMobRawCallback callback) {
        new StackMobRequestWithoutPayload(this.executor, this.session, StackMob.OAuthVersion.One, verb, StackMobOptions.none(), arguments, path, callback, this.redirectedCallback).setUrlFormat(this.host).sendRequest();
    }
}

