/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ApplicationAttachmentContentType;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class ApplicationAttachment {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="file_name")
    private JsonNullable<String> fileName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="content")
    private JsonNullable<String> content;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="url")
    private JsonNullable<String> url;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="content_type")
    private JsonNullable<? extends ApplicationAttachmentContentType> contentType;

    @JsonCreator
    public ApplicationAttachment(@JsonProperty(value="file_name") JsonNullable<String> fileName, @JsonProperty(value="content") JsonNullable<String> content, @JsonProperty(value="url") JsonNullable<String> url, @JsonProperty(value="content_type") JsonNullable<? extends ApplicationAttachmentContentType> contentType) {
        Utils.checkNotNull(fileName, "fileName");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(contentType, "contentType");
        this.fileName = fileName;
        this.content = content;
        this.url = url;
        this.contentType = contentType;
    }

    public ApplicationAttachment() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends ApplicationAttachmentContentType>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> fileName() {
        return this.fileName;
    }

    @JsonIgnore
    public JsonNullable<String> content() {
        return this.content;
    }

    @JsonIgnore
    public JsonNullable<String> url() {
        return this.url;
    }

    @JsonIgnore
    public JsonNullable<ApplicationAttachmentContentType> contentType() {
        return this.contentType;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ApplicationAttachment withFileName(String fileName) {
        Utils.checkNotNull(fileName, "fileName");
        this.fileName = JsonNullable.of((Object)fileName);
        return this;
    }

    public ApplicationAttachment withFileName(JsonNullable<String> fileName) {
        Utils.checkNotNull(fileName, "fileName");
        this.fileName = fileName;
        return this;
    }

    public ApplicationAttachment withContent(String content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of((Object)content);
        return this;
    }

    public ApplicationAttachment withContent(JsonNullable<String> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    public ApplicationAttachment withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of((Object)url);
        return this;
    }

    public ApplicationAttachment withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public ApplicationAttachment withContentType(ApplicationAttachmentContentType contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = JsonNullable.of((Object)contentType);
        return this;
    }

    public ApplicationAttachment withContentType(JsonNullable<? extends ApplicationAttachmentContentType> contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationAttachment other = (ApplicationAttachment)o;
        return Objects.deepEquals(this.fileName, other.fileName) && Objects.deepEquals(this.content, other.content) && Objects.deepEquals(this.url, other.url) && Objects.deepEquals(this.contentType, other.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.content, this.url, this.contentType);
    }

    public String toString() {
        return Utils.toString(ApplicationAttachment.class, "fileName", this.fileName, "content", this.content, "url", this.url, "contentType", this.contentType);
    }

    public static final class Builder {
        private JsonNullable<String> fileName = JsonNullable.undefined();
        private JsonNullable<String> content = JsonNullable.undefined();
        private JsonNullable<String> url = JsonNullable.undefined();
        private JsonNullable<? extends ApplicationAttachmentContentType> contentType = JsonNullable.undefined();

        private Builder() {
        }

        public Builder fileName(String fileName) {
            Utils.checkNotNull(fileName, "fileName");
            this.fileName = JsonNullable.of((Object)fileName);
            return this;
        }

        public Builder fileName(JsonNullable<String> fileName) {
            Utils.checkNotNull(fileName, "fileName");
            this.fileName = fileName;
            return this;
        }

        public Builder content(String content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of((Object)content);
            return this;
        }

        public Builder content(JsonNullable<String> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of((Object)url);
            return this;
        }

        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder contentType(ApplicationAttachmentContentType contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = JsonNullable.of((Object)contentType);
            return this;
        }

        public Builder contentType(JsonNullable<? extends ApplicationAttachmentContentType> contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public ApplicationAttachment build() {
            return new ApplicationAttachment(this.fileName, this.content, this.url, this.contentType);
        }
    }
}

