/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.JobPostingsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AtsListJobPostingsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends JobPostingsPaginated> jobPostingsPaginated;
    private Map<String, List<String>> headers;
    private Callable<Optional<AtsListJobPostingsResponse>> next = () -> Optional.empty();

    @JsonCreator
    public AtsListJobPostingsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends JobPostingsPaginated> jobPostingsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(jobPostingsPaginated, "jobPostingsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.jobPostingsPaginated = jobPostingsPaginated;
        this.headers = headers;
    }

    public AtsListJobPostingsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<JobPostingsPaginated> jobPostingsPaginated() {
        return this.jobPostingsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Optional<AtsListJobPostingsResponse> next() throws Exception {
        return this.next.call();
    }

    private AtsListJobPostingsResponse withNext(Callable<Optional<AtsListJobPostingsResponse>> next) {
        this.next = next;
        return this;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsListJobPostingsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListJobPostingsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListJobPostingsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListJobPostingsResponse withJobPostingsPaginated(JobPostingsPaginated jobPostingsPaginated) {
        Utils.checkNotNull(jobPostingsPaginated, "jobPostingsPaginated");
        this.jobPostingsPaginated = Optional.ofNullable(jobPostingsPaginated);
        return this;
    }

    public AtsListJobPostingsResponse withJobPostingsPaginated(Optional<? extends JobPostingsPaginated> jobPostingsPaginated) {
        Utils.checkNotNull(jobPostingsPaginated, "jobPostingsPaginated");
        this.jobPostingsPaginated = jobPostingsPaginated;
        return this;
    }

    public AtsListJobPostingsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListJobPostingsResponse other = (AtsListJobPostingsResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.jobPostingsPaginated, other.jobPostingsPaginated) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.jobPostingsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListJobPostingsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "jobPostingsPaginated", this.jobPostingsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private Callable<Optional<AtsListJobPostingsResponse>> next;
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends JobPostingsPaginated> jobPostingsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder jobPostingsPaginated(JobPostingsPaginated jobPostingsPaginated) {
            Utils.checkNotNull(jobPostingsPaginated, "jobPostingsPaginated");
            this.jobPostingsPaginated = Optional.ofNullable(jobPostingsPaginated);
            return this;
        }

        public Builder jobPostingsPaginated(Optional<? extends JobPostingsPaginated> jobPostingsPaginated) {
            Utils.checkNotNull(jobPostingsPaginated, "jobPostingsPaginated");
            this.jobPostingsPaginated = jobPostingsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        @Deprecated
        public Builder next(Callable<Optional<AtsListJobPostingsResponse>> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public AtsListJobPostingsResponse build() {
            return new AtsListJobPostingsResponse(this.contentType, this.statusCode, this.rawResponse, this.jobPostingsPaginated, this.headers).withNext(this.next);
        }
    }
}

