/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.RawResponse;
import com.stackone.stackone_client_java.models.components.TimeEntries;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class TimeEntriesResult {
    @JsonProperty(value="data")
    private TimeEntries data;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="raw")
    private JsonNullable<? extends List<RawResponse>> raw;

    @JsonCreator
    public TimeEntriesResult(@JsonProperty(value="data") TimeEntries data, @JsonProperty(value="raw") JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(raw, "raw");
        this.data = data;
        this.raw = raw;
    }

    public TimeEntriesResult(TimeEntries data) {
        this(data, (JsonNullable<? extends List<RawResponse>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public TimeEntries data() {
        return this.data;
    }

    @JsonIgnore
    public JsonNullable<List<RawResponse>> raw() {
        return this.raw;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public TimeEntriesResult withData(TimeEntries data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    public TimeEntriesResult withRaw(List<RawResponse> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = JsonNullable.of(raw);
        return this;
    }

    public TimeEntriesResult withRaw(JsonNullable<? extends List<RawResponse>> raw) {
        Utils.checkNotNull(raw, "raw");
        this.raw = raw;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeEntriesResult other = (TimeEntriesResult)o;
        return Objects.deepEquals(this.data, other.data) && Objects.deepEquals(this.raw, other.raw);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.raw);
    }

    public String toString() {
        return Utils.toString(TimeEntriesResult.class, "data", this.data, "raw", this.raw);
    }

    public static final class Builder {
        private TimeEntries data;
        private JsonNullable<? extends List<RawResponse>> raw = JsonNullable.undefined();

        private Builder() {
        }

        public Builder data(TimeEntries data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }

        public Builder raw(List<RawResponse> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = JsonNullable.of(raw);
            return this;
        }

        public Builder raw(JsonNullable<? extends List<RawResponse>> raw) {
            Utils.checkNotNull(raw, "raw");
            this.raw = raw;
            return this;
        }

        public TimeEntriesResult build() {
            return new TimeEntriesResult(this.data, this.raw);
        }
    }
}

