/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Objects;

public class StackoneProxyRequestRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private ProxyRequestBody proxyRequestBody;

    @JsonCreator
    public StackoneProxyRequestRequest(String xAccountId, ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.xAccountId = xAccountId;
        this.proxyRequestBody = proxyRequestBody;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public ProxyRequestBody proxyRequestBody() {
        return this.proxyRequestBody;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public StackoneProxyRequestRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public StackoneProxyRequestRequest withProxyRequestBody(ProxyRequestBody proxyRequestBody) {
        Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
        this.proxyRequestBody = proxyRequestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneProxyRequestRequest other = (StackoneProxyRequestRequest)o;
        return Objects.deepEquals(this.xAccountId, other.xAccountId) && Objects.deepEquals(this.proxyRequestBody, other.proxyRequestBody);
    }

    public int hashCode() {
        return Objects.hash(this.xAccountId, this.proxyRequestBody);
    }

    public String toString() {
        return Utils.toString(StackoneProxyRequestRequest.class, "xAccountId", this.xAccountId, "proxyRequestBody", this.proxyRequestBody);
    }

    public static final class Builder {
        private String xAccountId;
        private ProxyRequestBody proxyRequestBody;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder proxyRequestBody(ProxyRequestBody proxyRequestBody) {
            Utils.checkNotNull(proxyRequestBody, "proxyRequestBody");
            this.proxyRequestBody = proxyRequestBody;
            return this;
        }

        public StackoneProxyRequestRequest build() {
            return new StackoneProxyRequestRequest(this.xAccountId, this.proxyRequestBody);
        }
    }
}

