/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.SpeakeasyHTTPClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public final class RecordingClient
implements HTTPClient {
    private final List<HttpRequest> requests = new CopyOnWriteArrayList<HttpRequest>();
    private final HTTPClient client;
    private final List<Function<HttpRequest, HttpRequest>> beforeRequestHooks = new ArrayList<Function<HttpRequest, HttpRequest>>();

    public RecordingClient() {
        this.client = new SpeakeasyHTTPClient();
    }

    @Override
    public HttpResponse<InputStream> send(HttpRequest request) throws IOException, InterruptedException, URISyntaxException {
        for (Function<HttpRequest, HttpRequest> hook : this.beforeRequestHooks) {
            request = hook.apply(request);
        }
        this.requests.add(request);
        return this.client.send(request);
    }

    public List<HttpRequest> requests() {
        return this.requests;
    }

    public RecordingClient beforeRequest(Function<HttpRequest, HttpRequest> hook) {
        this.beforeRequestHooks.add(hook);
        return this;
    }

    public void reset() {
        this.requests.clear();
    }
}

