/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.HrisUpdateEmployeeRequestDto;
import com.stackone.stackone_client_java.models.operations.HrisUpdateEmployeeRequest;
import com.stackone.stackone_client_java.models.operations.HrisUpdateEmployeeResponse;
import com.stackone.stackone_client_java.operations.HrisUpdateEmployee;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class HrisUpdateEmployeeRequestBuilder {
    private String xAccountId;
    private String id;
    private HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisUpdateEmployeeRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisUpdateEmployeeRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public HrisUpdateEmployeeRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public HrisUpdateEmployeeRequestBuilder hrisUpdateEmployeeRequestDto(HrisUpdateEmployeeRequestDto hrisUpdateEmployeeRequestDto) {
        Utils.checkNotNull(hrisUpdateEmployeeRequestDto, "hrisUpdateEmployeeRequestDto");
        this.hrisUpdateEmployeeRequestDto = hrisUpdateEmployeeRequestDto;
        return this;
    }

    public HrisUpdateEmployeeRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisUpdateEmployeeRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private HrisUpdateEmployeeRequest buildRequest() {
        HrisUpdateEmployeeRequest request = new HrisUpdateEmployeeRequest(this.xAccountId, this.id, this.hrisUpdateEmployeeRequestDto);
        return request;
    }

    public HrisUpdateEmployeeResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisUpdateEmployee.Sync operation = new HrisUpdateEmployee.Sync(this.sdkConfiguration, options);
        HrisUpdateEmployeeRequest request = this.buildRequest();
        return (HrisUpdateEmployeeResponse)operation.handleResponse(operation.doRequest(request));
    }
}

