/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CampaignsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingListCampaignsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends CampaignsPaginated> campaignsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingListCampaignsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends CampaignsPaginated> campaignsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(campaignsPaginated, "campaignsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.campaignsPaginated = campaignsPaginated;
        this.headers = headers;
    }

    public MarketingListCampaignsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CampaignsPaginated> campaignsPaginated() {
        return this.campaignsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MarketingListCampaignsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public MarketingListCampaignsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public MarketingListCampaignsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public MarketingListCampaignsResponse withCampaignsPaginated(CampaignsPaginated campaignsPaginated) {
        Utils.checkNotNull(campaignsPaginated, "campaignsPaginated");
        this.campaignsPaginated = Optional.ofNullable(campaignsPaginated);
        return this;
    }

    public MarketingListCampaignsResponse withCampaignsPaginated(Optional<? extends CampaignsPaginated> campaignsPaginated) {
        Utils.checkNotNull(campaignsPaginated, "campaignsPaginated");
        this.campaignsPaginated = campaignsPaginated;
        return this;
    }

    public MarketingListCampaignsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketingListCampaignsResponse other = (MarketingListCampaignsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.campaignsPaginated, other.campaignsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.campaignsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(MarketingListCampaignsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "campaignsPaginated", this.campaignsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends CampaignsPaginated> campaignsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder campaignsPaginated(CampaignsPaginated campaignsPaginated) {
            Utils.checkNotNull(campaignsPaginated, "campaignsPaginated");
            this.campaignsPaginated = Optional.ofNullable(campaignsPaginated);
            return this;
        }

        public Builder campaignsPaginated(Optional<? extends CampaignsPaginated> campaignsPaginated) {
            Utils.checkNotNull(campaignsPaginated, "campaignsPaginated");
            this.campaignsPaginated = campaignsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MarketingListCampaignsResponse build() {
            return new MarketingListCampaignsResponse(this.contentType, this.statusCode, this.rawResponse, this.campaignsPaginated, this.headers);
        }
    }
}

