/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * EmploymentDurationUnit
 * 
 * <p>The duration unit of the work time
 */
public class EmploymentDurationUnit {
    /**
     * The unified value for the period.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends EmploymentWorkTimeValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends EmploymentWorkTimeSourceValue> sourceValue;

    @JsonCreator
    public EmploymentDurationUnit(
            @JsonProperty("value") JsonNullable<? extends EmploymentWorkTimeValue> value,
            @JsonProperty("source_value") JsonNullable<? extends EmploymentWorkTimeSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public EmploymentDurationUnit() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified value for the period.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentWorkTimeValue> value() {
        return (JsonNullable<EmploymentWorkTimeValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentWorkTimeSourceValue> sourceValue() {
        return (JsonNullable<EmploymentWorkTimeSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The unified value for the period.
     */
    public EmploymentDurationUnit withValue(EmploymentWorkTimeValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified value for the period.
     */
    public EmploymentDurationUnit withValue(JsonNullable<? extends EmploymentWorkTimeValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public EmploymentDurationUnit withSourceValue(EmploymentWorkTimeSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public EmploymentDurationUnit withSourceValue(JsonNullable<? extends EmploymentWorkTimeSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmploymentDurationUnit other = (EmploymentDurationUnit) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(EmploymentDurationUnit.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends EmploymentWorkTimeValue> value = JsonNullable.undefined();

        private JsonNullable<? extends EmploymentWorkTimeSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The unified value for the period.
         */
        public Builder value(EmploymentWorkTimeValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified value for the period.
         */
        public Builder value(JsonNullable<? extends EmploymentWorkTimeValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(EmploymentWorkTimeSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends EmploymentWorkTimeSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public EmploymentDurationUnit build() {

            return new EmploymentDurationUnit(
                value, sourceValue);
        }

    }
}
