/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/**
 * Manages the parsing of an InputStream in SSE (Server Sent Events) format.
 *
 * @param <T> the type that the SSE {@code data} field is deserialized into
 */
public final class EventStream<T> implements AutoCloseable {
    private final BlockingParser<EventStreamMessage> parser;
    private final TypeReference<T> typeReference;
    private final ObjectMapper mapper;
    private final Optional<String> terminalMessage;

    // Internal use only
    public EventStream(InputStream in, TypeReference<T> typeReference, ObjectMapper mapper, Optional<String> terminalMessage) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8), 8192);
        this.parser = BlockingParser.forSSE(reader);
        this.typeReference = typeReference;
        this.mapper = mapper;
        this.terminalMessage = terminalMessage;
    }

    /**
     * Returns the next message. If another message does not exist returns
     * {@code Optional.empty()}.
     *
     * @return the next message or {@code Optional.empty()} if no more messages
     * @throws IOException when parsing the next message.
     */
    public Optional<T> next() throws IOException {
        return parser.next() //
                .filter(x ->
                        terminalMessage.map(sentinel -> !sentinel.equals(x.data())).orElse(true))
                .map(x -> Utils.asType(x, mapper, typeReference));
    }

    /**
     * Reads all events and returns them as a {@code List}. This method calls
     * {@code close()}.
     *
     * @return list of events
     */
    public List<T> toList() {
        try {
            return stream().collect(Collectors.toList());
        } finally {
            try {
                close();
            } catch (IOException e) {
                throw new UncheckedIOException(e);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /**
     * Returns a {@link Stream} of events. Must be closed after use!
     *
     * @return streamed events
     */
    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>() {
            Optional<T> next = Optional.empty();

            public T next() {
                load();
                if (next.isEmpty()) {
                    throw new NoSuchElementException();
                }
                T v = next.get();
                next = Optional.empty();
                return v;
            }

            public boolean hasNext() {
                load();
                return next.isPresent();
            }

            private void load() {
                if (next.isEmpty()) {
                    try {
                        next = EventStream.this.next();
                    } catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }, Spliterator.ORDERED), false).onClose(() -> {
            try {
                EventStream.this.close();
            } catch (IOException e) {
                throw new UncheckedIOException(e);
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() throws IOException {
        parser.close();
    }
}
