/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class Input {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="query")
    private JsonNullable<? extends Map<String, Object>> query;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="headers")
    private JsonNullable<? extends Map<String, Object>> headers;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="body")
    private JsonNullable<? extends Map<String, Object>> body;

    @JsonCreator
    public Input(@JsonProperty(value="query") JsonNullable<? extends Map<String, Object>> query, @JsonProperty(value="headers") JsonNullable<? extends Map<String, Object>> headers, @JsonProperty(value="body") JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(query, "query");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(body, "body");
        this.query = query;
        this.headers = headers;
        this.body = body;
    }

    public Input() {
        this((JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined(), (JsonNullable<? extends Map<String, Object>>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> query() {
        return this.query;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return this.headers;
    }

    @JsonIgnore
    public JsonNullable<Map<String, Object>> body() {
        return this.body;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Input withQuery(Map<String, Object> query) {
        Utils.checkNotNull(query, "query");
        this.query = JsonNullable.of(query);
        return this;
    }

    public Input withQuery(JsonNullable<? extends Map<String, Object>> query) {
        Utils.checkNotNull(query, "query");
        this.query = query;
        return this;
    }

    public Input withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    public Input withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public Input withBody(Map<String, Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    public Input withBody(JsonNullable<? extends Map<String, Object>> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input other = (Input)o;
        return Utils.enhancedDeepEquals(this.query, other.query) && Utils.enhancedDeepEquals(this.headers, other.headers) && Utils.enhancedDeepEquals(this.body, other.body);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.query, this.headers, this.body);
    }

    public String toString() {
        return Utils.toString(Input.class, "query", this.query, "headers", this.headers, "body", this.body);
    }

    public static final class Builder {
        private JsonNullable<? extends Map<String, Object>> query = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();
        private JsonNullable<? extends Map<String, Object>> body = JsonNullable.undefined();

        private Builder() {
        }

        public Builder query(Map<String, Object> query) {
            Utils.checkNotNull(query, "query");
            this.query = JsonNullable.of(query);
            return this;
        }

        public Builder query(JsonNullable<? extends Map<String, Object>> query) {
            Utils.checkNotNull(query, "query");
            this.query = query;
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public Builder body(Map<String, Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        public Builder body(JsonNullable<? extends Map<String, Object>> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }

        public Input build() {
            return new Input(this.query, this.headers, this.body);
        }
    }
}

