/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.Author;
import com.stackone.stackone_client_java.models.components.MessagingMessageContent;
import com.stackone.stackone_client_java.utils.Utils;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class MessagingMessage {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="id")
    private JsonNullable<String> id;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="remote_id")
    private JsonNullable<String> remoteId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="content")
    private JsonNullable<? extends MessagingMessageContent> content;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="parent_message_id")
    private JsonNullable<String> parentMessageId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="attachments")
    private JsonNullable<? extends List<String>> attachments;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="author")
    private JsonNullable<? extends Author> author;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="created_at")
    private JsonNullable<OffsetDateTime> createdAt;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public MessagingMessage(@JsonProperty(value="id") JsonNullable<String> id, @JsonProperty(value="remote_id") JsonNullable<String> remoteId, @JsonProperty(value="content") JsonNullable<? extends MessagingMessageContent> content, @JsonProperty(value="parent_message_id") JsonNullable<String> parentMessageId, @JsonProperty(value="attachments") JsonNullable<? extends List<String>> attachments, @JsonProperty(value="author") JsonNullable<? extends Author> author, @JsonProperty(value="created_at") JsonNullable<OffsetDateTime> createdAt, @JsonProperty(value="updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(content, "content");
        Utils.checkNotNull(parentMessageId, "parentMessageId");
        Utils.checkNotNull(attachments, "attachments");
        Utils.checkNotNull(author, "author");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.remoteId = remoteId;
        this.content = content;
        this.parentMessageId = parentMessageId;
        this.attachments = attachments;
        this.author = author;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public MessagingMessage() {
        this((JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends MessagingMessageContent>)JsonNullable.undefined(), (JsonNullable<String>)JsonNullable.undefined(), (JsonNullable<? extends List<String>>)JsonNullable.undefined(), (JsonNullable<? extends Author>)JsonNullable.undefined(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined(), (JsonNullable<OffsetDateTime>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> id() {
        return this.id;
    }

    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return this.remoteId;
    }

    @JsonIgnore
    public JsonNullable<MessagingMessageContent> content() {
        return this.content;
    }

    @JsonIgnore
    public JsonNullable<String> parentMessageId() {
        return this.parentMessageId;
    }

    @JsonIgnore
    public JsonNullable<List<String>> attachments() {
        return this.attachments;
    }

    @JsonIgnore
    public JsonNullable<Author> author() {
        return this.author;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MessagingMessage withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of((Object)id);
        return this;
    }

    public MessagingMessage withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public MessagingMessage withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of((Object)remoteId);
        return this;
    }

    public MessagingMessage withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    public MessagingMessage withContent(MessagingMessageContent content) {
        Utils.checkNotNull(content, "content");
        this.content = JsonNullable.of((Object)content);
        return this;
    }

    public MessagingMessage withContent(JsonNullable<? extends MessagingMessageContent> content) {
        Utils.checkNotNull(content, "content");
        this.content = content;
        return this;
    }

    public MessagingMessage withParentMessageId(String parentMessageId) {
        Utils.checkNotNull(parentMessageId, "parentMessageId");
        this.parentMessageId = JsonNullable.of((Object)parentMessageId);
        return this;
    }

    public MessagingMessage withParentMessageId(JsonNullable<String> parentMessageId) {
        Utils.checkNotNull(parentMessageId, "parentMessageId");
        this.parentMessageId = parentMessageId;
        return this;
    }

    public MessagingMessage withAttachments(List<String> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = JsonNullable.of(attachments);
        return this;
    }

    public MessagingMessage withAttachments(JsonNullable<? extends List<String>> attachments) {
        Utils.checkNotNull(attachments, "attachments");
        this.attachments = attachments;
        return this;
    }

    public MessagingMessage withAuthor(Author author) {
        Utils.checkNotNull(author, "author");
        this.author = JsonNullable.of((Object)author);
        return this;
    }

    public MessagingMessage withAuthor(JsonNullable<? extends Author> author) {
        Utils.checkNotNull(author, "author");
        this.author = author;
        return this;
    }

    public MessagingMessage withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of((Object)createdAt);
        return this;
    }

    public MessagingMessage withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public MessagingMessage withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of((Object)updatedAt);
        return this;
    }

    public MessagingMessage withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingMessage other = (MessagingMessage)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.remoteId, other.remoteId) && Utils.enhancedDeepEquals(this.content, other.content) && Utils.enhancedDeepEquals(this.parentMessageId, other.parentMessageId) && Utils.enhancedDeepEquals(this.attachments, other.attachments) && Utils.enhancedDeepEquals(this.author, other.author) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.remoteId, this.content, this.parentMessageId, this.attachments, this.author, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return Utils.toString(MessagingMessage.class, "id", this.id, "remoteId", this.remoteId, "content", this.content, "parentMessageId", this.parentMessageId, "attachments", this.attachments, "author", this.author, "createdAt", this.createdAt, "updatedAt", this.updatedAt);
    }

    public static final class Builder {
        private JsonNullable<String> id = JsonNullable.undefined();
        private JsonNullable<String> remoteId = JsonNullable.undefined();
        private JsonNullable<? extends MessagingMessageContent> content = JsonNullable.undefined();
        private JsonNullable<String> parentMessageId = JsonNullable.undefined();
        private JsonNullable<? extends List<String>> attachments = JsonNullable.undefined();
        private JsonNullable<? extends Author> author = JsonNullable.undefined();
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of((Object)id);
            return this;
        }

        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of((Object)remoteId);
            return this;
        }

        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        public Builder content(MessagingMessageContent content) {
            Utils.checkNotNull(content, "content");
            this.content = JsonNullable.of((Object)content);
            return this;
        }

        public Builder content(JsonNullable<? extends MessagingMessageContent> content) {
            Utils.checkNotNull(content, "content");
            this.content = content;
            return this;
        }

        public Builder parentMessageId(String parentMessageId) {
            Utils.checkNotNull(parentMessageId, "parentMessageId");
            this.parentMessageId = JsonNullable.of((Object)parentMessageId);
            return this;
        }

        public Builder parentMessageId(JsonNullable<String> parentMessageId) {
            Utils.checkNotNull(parentMessageId, "parentMessageId");
            this.parentMessageId = parentMessageId;
            return this;
        }

        public Builder attachments(List<String> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = JsonNullable.of(attachments);
            return this;
        }

        public Builder attachments(JsonNullable<? extends List<String>> attachments) {
            Utils.checkNotNull(attachments, "attachments");
            this.attachments = attachments;
            return this;
        }

        public Builder author(Author author) {
            Utils.checkNotNull(author, "author");
            this.author = JsonNullable.of((Object)author);
            return this;
        }

        public Builder author(JsonNullable<? extends Author> author) {
            Utils.checkNotNull(author, "author");
            this.author = author;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of((Object)createdAt);
            return this;
        }

        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of((Object)updatedAt);
            return this;
        }

        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public MessagingMessage build() {
            return new MessagingMessage(this.id, this.remoteId, this.content, this.parentMessageId, this.attachments, this.author, this.createdAt, this.updatedAt);
        }
    }
}

