/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingCommentsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingListCommentsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends TicketingCommentsPaginated> ticketingCommentsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingListCommentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends TicketingCommentsPaginated> ticketingCommentsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingCommentsPaginated, "ticketingCommentsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingCommentsPaginated = ticketingCommentsPaginated;
        this.headers = headers;
    }

    public TicketingListCommentsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingCommentsPaginated> ticketingCommentsPaginated() {
        return this.ticketingCommentsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingListCommentsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingListCommentsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingListCommentsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingListCommentsResponse withTicketingCommentsPaginated(TicketingCommentsPaginated ticketingCommentsPaginated) {
        Utils.checkNotNull(ticketingCommentsPaginated, "ticketingCommentsPaginated");
        this.ticketingCommentsPaginated = Optional.ofNullable(ticketingCommentsPaginated);
        return this;
    }

    public TicketingListCommentsResponse withTicketingCommentsPaginated(Optional<? extends TicketingCommentsPaginated> ticketingCommentsPaginated) {
        Utils.checkNotNull(ticketingCommentsPaginated, "ticketingCommentsPaginated");
        this.ticketingCommentsPaginated = ticketingCommentsPaginated;
        return this;
    }

    public TicketingListCommentsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingListCommentsResponse other = (TicketingListCommentsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingCommentsPaginated, other.ticketingCommentsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingCommentsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingListCommentsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingCommentsPaginated", this.ticketingCommentsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends TicketingCommentsPaginated> ticketingCommentsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingCommentsPaginated(TicketingCommentsPaginated ticketingCommentsPaginated) {
            Utils.checkNotNull(ticketingCommentsPaginated, "ticketingCommentsPaginated");
            this.ticketingCommentsPaginated = Optional.ofNullable(ticketingCommentsPaginated);
            return this;
        }

        public Builder ticketingCommentsPaginated(Optional<? extends TicketingCommentsPaginated> ticketingCommentsPaginated) {
            Utils.checkNotNull(ticketingCommentsPaginated, "ticketingCommentsPaginated");
            this.ticketingCommentsPaginated = ticketingCommentsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingListCommentsResponse build() {
            return new TicketingListCommentsResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingCommentsPaginated, this.headers);
        }
    }
}

