/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListTicketsResponse;
import com.stackone.stackone_client_java.operations.TicketingListTickets;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class TicketingListTicketsRequestBuilder {
    private TicketingListTicketsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public TicketingListTicketsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingListTicketsRequestBuilder request(TicketingListTicketsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public TicketingListTicketsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingListTicketsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public TicketingListTicketsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListTickets.Sync operation = new TicketingListTickets.Sync(this.sdkConfiguration, options);
        return (TicketingListTicketsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<TicketingListTicketsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListTickets.Sync operation = new TicketingListTickets.Sync(this.sdkConfiguration, options);
        Paginator<TicketingListTicketsRequest, String> iterator = new Paginator<TicketingListTicketsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), TicketingListTicketsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<TicketingListTicketsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

