/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingCompaniesPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AccountingListCompaniesResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends AccountingCompaniesPaginated> accountingCompaniesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AccountingListCompaniesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends AccountingCompaniesPaginated> accountingCompaniesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(accountingCompaniesPaginated, "accountingCompaniesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.accountingCompaniesPaginated = accountingCompaniesPaginated;
        this.headers = headers;
    }

    public AccountingListCompaniesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AccountingCompaniesPaginated> accountingCompaniesPaginated() {
        return this.accountingCompaniesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingListCompaniesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AccountingListCompaniesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AccountingListCompaniesResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AccountingListCompaniesResponse withAccountingCompaniesPaginated(AccountingCompaniesPaginated accountingCompaniesPaginated) {
        Utils.checkNotNull(accountingCompaniesPaginated, "accountingCompaniesPaginated");
        this.accountingCompaniesPaginated = Optional.ofNullable(accountingCompaniesPaginated);
        return this;
    }

    public AccountingListCompaniesResponse withAccountingCompaniesPaginated(Optional<? extends AccountingCompaniesPaginated> accountingCompaniesPaginated) {
        Utils.checkNotNull(accountingCompaniesPaginated, "accountingCompaniesPaginated");
        this.accountingCompaniesPaginated = accountingCompaniesPaginated;
        return this;
    }

    public AccountingListCompaniesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingListCompaniesResponse other = (AccountingListCompaniesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.accountingCompaniesPaginated, other.accountingCompaniesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.accountingCompaniesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AccountingListCompaniesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "accountingCompaniesPaginated", this.accountingCompaniesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends AccountingCompaniesPaginated> accountingCompaniesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder accountingCompaniesPaginated(AccountingCompaniesPaginated accountingCompaniesPaginated) {
            Utils.checkNotNull(accountingCompaniesPaginated, "accountingCompaniesPaginated");
            this.accountingCompaniesPaginated = Optional.ofNullable(accountingCompaniesPaginated);
            return this;
        }

        public Builder accountingCompaniesPaginated(Optional<? extends AccountingCompaniesPaginated> accountingCompaniesPaginated) {
            Utils.checkNotNull(accountingCompaniesPaginated, "accountingCompaniesPaginated");
            this.accountingCompaniesPaginated = accountingCompaniesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AccountingListCompaniesResponse build() {
            return new AccountingListCompaniesResponse(this.contentType, this.statusCode, this.rawResponse, this.accountingCompaniesPaginated, this.headers);
        }
    }
}

