/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.UnifiedLogsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StackoneListLogsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends UnifiedLogsPaginated> unifiedLogsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public StackoneListLogsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends UnifiedLogsPaginated> unifiedLogsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(unifiedLogsPaginated, "unifiedLogsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.unifiedLogsPaginated = unifiedLogsPaginated;
        this.headers = headers;
    }

    public StackoneListLogsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<UnifiedLogsPaginated> unifiedLogsPaginated() {
        return this.unifiedLogsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public StackoneListLogsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public StackoneListLogsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public StackoneListLogsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public StackoneListLogsResponse withUnifiedLogsPaginated(UnifiedLogsPaginated unifiedLogsPaginated) {
        Utils.checkNotNull(unifiedLogsPaginated, "unifiedLogsPaginated");
        this.unifiedLogsPaginated = Optional.ofNullable(unifiedLogsPaginated);
        return this;
    }

    public StackoneListLogsResponse withUnifiedLogsPaginated(Optional<? extends UnifiedLogsPaginated> unifiedLogsPaginated) {
        Utils.checkNotNull(unifiedLogsPaginated, "unifiedLogsPaginated");
        this.unifiedLogsPaginated = unifiedLogsPaginated;
        return this;
    }

    public StackoneListLogsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StackoneListLogsResponse other = (StackoneListLogsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.unifiedLogsPaginated, other.unifiedLogsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.unifiedLogsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(StackoneListLogsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "unifiedLogsPaginated", this.unifiedLogsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends UnifiedLogsPaginated> unifiedLogsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder unifiedLogsPaginated(UnifiedLogsPaginated unifiedLogsPaginated) {
            Utils.checkNotNull(unifiedLogsPaginated, "unifiedLogsPaginated");
            this.unifiedLogsPaginated = Optional.ofNullable(unifiedLogsPaginated);
            return this;
        }

        public Builder unifiedLogsPaginated(Optional<? extends UnifiedLogsPaginated> unifiedLogsPaginated) {
            Utils.checkNotNull(unifiedLogsPaginated, "unifiedLogsPaginated");
            this.unifiedLogsPaginated = unifiedLogsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public StackoneListLogsResponse build() {
            return new StackoneListLogsResponse(this.contentType, this.statusCode, this.rawResponse, this.unifiedLogsPaginated, this.headers);
        }
    }
}

