/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneListPlatformLogsRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneListPlatformLogsResponse;
import com.stackone.stackone_client_java.operations.StackoneListPlatformLogs;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class StackoneListPlatformLogsRequestBuilder {
    private StackoneListPlatformLogsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public StackoneListPlatformLogsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public StackoneListPlatformLogsRequestBuilder request(StackoneListPlatformLogsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public StackoneListPlatformLogsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneListPlatformLogsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CompletableFuture<StackoneListPlatformLogsResponse> call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        StackoneListPlatformLogs.Async operation = new StackoneListPlatformLogs.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(this.request).thenCompose(operation::handleResponse);
    }
}

