/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HrisShiftsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListEmployeeShiftsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListEmployeeShiftsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisShiftsPaginated = hrisShiftsPaginated;
        this.headers = headers;
    }

    public HrisListEmployeeShiftsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HrisShiftsPaginated> hrisShiftsPaginated() {
        return this.hrisShiftsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisListEmployeeShiftsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListEmployeeShiftsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListEmployeeShiftsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListEmployeeShiftsResponse withHrisShiftsPaginated(HrisShiftsPaginated hrisShiftsPaginated) {
        Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
        this.hrisShiftsPaginated = Optional.ofNullable(hrisShiftsPaginated);
        return this;
    }

    public HrisListEmployeeShiftsResponse withHrisShiftsPaginated(Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated) {
        Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
        this.hrisShiftsPaginated = hrisShiftsPaginated;
        return this;
    }

    public HrisListEmployeeShiftsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListEmployeeShiftsResponse other = (HrisListEmployeeShiftsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisShiftsPaginated, other.hrisShiftsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListEmployeeShiftsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisShiftsPaginated", this.hrisShiftsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisShiftsPaginated(HrisShiftsPaginated hrisShiftsPaginated) {
            Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
            this.hrisShiftsPaginated = Optional.ofNullable(hrisShiftsPaginated);
            return this;
        }

        public Builder hrisShiftsPaginated(Optional<? extends HrisShiftsPaginated> hrisShiftsPaginated) {
            Utils.checkNotNull(hrisShiftsPaginated, "hrisShiftsPaginated");
            this.hrisShiftsPaginated = hrisShiftsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListEmployeeShiftsResponse build() {
            return new HrisListEmployeeShiftsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisShiftsPaginated, this.headers);
        }
    }
}

