/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectsRequest;
import com.stackone.stackone_client_java.models.operations.TicketingListProjectsResponse;
import com.stackone.stackone_client_java.operations.TicketingListProjects;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class TicketingListProjectsRequestBuilder {
    private TicketingListProjectsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public TicketingListProjectsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public TicketingListProjectsRequestBuilder request(TicketingListProjectsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public TicketingListProjectsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public TicketingListProjectsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public TicketingListProjectsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListProjects.Sync operation = new TicketingListProjects.Sync(this.sdkConfiguration, options, this._headers);
        return (TicketingListProjectsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<TicketingListProjectsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        TicketingListProjects.Sync operation = new TicketingListProjects.Sync(this.sdkConfiguration, options, this._headers);
        Paginator<TicketingListProjectsRequest, String> iterator = new Paginator<TicketingListProjectsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), TicketingListProjectsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<TicketingListProjectsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

