/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ApplicationStagesPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsListJobApplicationStagesResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends ApplicationStagesPaginated> applicationStagesPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsListJobApplicationStagesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends ApplicationStagesPaginated> applicationStagesPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(applicationStagesPaginated, "applicationStagesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.applicationStagesPaginated = applicationStagesPaginated;
        this.headers = headers;
    }

    public AtsListJobApplicationStagesResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ApplicationStagesPaginated> applicationStagesPaginated() {
        return this.applicationStagesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsListJobApplicationStagesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsListJobApplicationStagesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsListJobApplicationStagesResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsListJobApplicationStagesResponse withApplicationStagesPaginated(ApplicationStagesPaginated applicationStagesPaginated) {
        Utils.checkNotNull(applicationStagesPaginated, "applicationStagesPaginated");
        this.applicationStagesPaginated = Optional.ofNullable(applicationStagesPaginated);
        return this;
    }

    public AtsListJobApplicationStagesResponse withApplicationStagesPaginated(Optional<? extends ApplicationStagesPaginated> applicationStagesPaginated) {
        Utils.checkNotNull(applicationStagesPaginated, "applicationStagesPaginated");
        this.applicationStagesPaginated = applicationStagesPaginated;
        return this;
    }

    public AtsListJobApplicationStagesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsListJobApplicationStagesResponse other = (AtsListJobApplicationStagesResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.applicationStagesPaginated, other.applicationStagesPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.applicationStagesPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsListJobApplicationStagesResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "applicationStagesPaginated", this.applicationStagesPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends ApplicationStagesPaginated> applicationStagesPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder applicationStagesPaginated(ApplicationStagesPaginated applicationStagesPaginated) {
            Utils.checkNotNull(applicationStagesPaginated, "applicationStagesPaginated");
            this.applicationStagesPaginated = Optional.ofNullable(applicationStagesPaginated);
            return this;
        }

        public Builder applicationStagesPaginated(Optional<? extends ApplicationStagesPaginated> applicationStagesPaginated) {
            Utils.checkNotNull(applicationStagesPaginated, "applicationStagesPaginated");
            this.applicationStagesPaginated = applicationStagesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsListJobApplicationStagesResponse build() {
            return new AtsListJobApplicationStagesResponse(this.contentType, this.statusCode, this.rawResponse, this.applicationStagesPaginated, this.headers);
        }
    }
}

