/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingProjectsPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingListProjectsResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TicketingProjectsPaginated> ticketingProjectsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingListProjectsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TicketingProjectsPaginated> ticketingProjectsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingProjectsPaginated, "ticketingProjectsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingProjectsPaginated = ticketingProjectsPaginated;
        this.headers = headers;
    }

    public TicketingListProjectsResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingProjectsPaginated> ticketingProjectsPaginated() {
        return this.ticketingProjectsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingListProjectsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingListProjectsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingListProjectsResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingListProjectsResponse withTicketingProjectsPaginated(TicketingProjectsPaginated ticketingProjectsPaginated) {
        Utils.checkNotNull(ticketingProjectsPaginated, "ticketingProjectsPaginated");
        this.ticketingProjectsPaginated = Optional.ofNullable(ticketingProjectsPaginated);
        return this;
    }

    public TicketingListProjectsResponse withTicketingProjectsPaginated(Optional<? extends TicketingProjectsPaginated> ticketingProjectsPaginated) {
        Utils.checkNotNull(ticketingProjectsPaginated, "ticketingProjectsPaginated");
        this.ticketingProjectsPaginated = ticketingProjectsPaginated;
        return this;
    }

    public TicketingListProjectsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingListProjectsResponse other = (TicketingListProjectsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingProjectsPaginated, other.ticketingProjectsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingProjectsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingListProjectsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingProjectsPaginated", this.ticketingProjectsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TicketingProjectsPaginated> ticketingProjectsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingProjectsPaginated(TicketingProjectsPaginated ticketingProjectsPaginated) {
            Utils.checkNotNull(ticketingProjectsPaginated, "ticketingProjectsPaginated");
            this.ticketingProjectsPaginated = Optional.ofNullable(ticketingProjectsPaginated);
            return this;
        }

        public Builder ticketingProjectsPaginated(Optional<? extends TicketingProjectsPaginated> ticketingProjectsPaginated) {
            Utils.checkNotNull(ticketingProjectsPaginated, "ticketingProjectsPaginated");
            this.ticketingProjectsPaginated = ticketingProjectsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingListProjectsResponse build() {
            return new TicketingListProjectsResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingProjectsPaginated, this.headers);
        }
    }
}

