/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class JournalLine {
    /**
     * Unique identifier for the journal line
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * ID of the ledger account this line references
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_id")
    private JsonNullable<String> accountId;

    /**
     * Type of the account
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_type")
    private JsonNullable<? extends AccountType> accountType;

    /**
     * Description of the journal line
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    /**
     * Currency code for this line
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("currency_code")
    private JsonNullable<? extends JournalLineCurrencyCode> currencyCode;

    /**
     * Exchange rate to company base currency
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("exchange_rate")
    private JsonNullable<Double> exchangeRate;

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative
     * for credit
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("amount")
    private JsonNullable<Double> amount;

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tax_amount")
    private JsonNullable<Double> taxAmount;

    /**
     * Tax rate percentage
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("tax_rate_percentage")
    private JsonNullable<Double> taxRatePercentage;

    @JsonCreator
    public JournalLine(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("account_id") JsonNullable<String> accountId,
            @JsonProperty("account_type") JsonNullable<? extends AccountType> accountType,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("currency_code") JsonNullable<? extends JournalLineCurrencyCode> currencyCode,
            @JsonProperty("exchange_rate") JsonNullable<Double> exchangeRate,
            @JsonProperty("amount") JsonNullable<Double> amount,
            @JsonProperty("tax_amount") JsonNullable<Double> taxAmount,
            @JsonProperty("tax_rate_percentage") JsonNullable<Double> taxRatePercentage) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(accountType, "accountType");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(currencyCode, "currencyCode");
        Utils.checkNotNull(exchangeRate, "exchangeRate");
        Utils.checkNotNull(amount, "amount");
        Utils.checkNotNull(taxAmount, "taxAmount");
        Utils.checkNotNull(taxRatePercentage, "taxRatePercentage");
        this.id = id;
        this.accountId = accountId;
        this.accountType = accountType;
        this.description = description;
        this.currencyCode = currencyCode;
        this.exchangeRate = exchangeRate;
        this.amount = amount;
        this.taxAmount = taxAmount;
        this.taxRatePercentage = taxRatePercentage;
    }
    
    public JournalLine() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier for the journal line
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * ID of the ledger account this line references
     */
    @JsonIgnore
    public JsonNullable<String> accountId() {
        return accountId;
    }

    /**
     * Type of the account
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AccountType> accountType() {
        return (JsonNullable<AccountType>) accountType;
    }

    /**
     * Description of the journal line
     */
    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    /**
     * Currency code for this line
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<JournalLineCurrencyCode> currencyCode() {
        return (JsonNullable<JournalLineCurrencyCode>) currencyCode;
    }

    /**
     * Exchange rate to company base currency
     */
    @JsonIgnore
    public JsonNullable<Double> exchangeRate() {
        return exchangeRate;
    }

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative
     * for credit
     */
    @JsonIgnore
    public JsonNullable<Double> amount() {
        return amount;
    }

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    @JsonIgnore
    public JsonNullable<Double> taxAmount() {
        return taxAmount;
    }

    /**
     * Tax rate percentage
     */
    @JsonIgnore
    public JsonNullable<Double> taxRatePercentage() {
        return taxRatePercentage;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Unique identifier for the journal line
     */
    public JournalLine withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier for the journal line
     */
    public JournalLine withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * ID of the ledger account this line references
     */
    public JournalLine withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = JsonNullable.of(accountId);
        return this;
    }

    /**
     * ID of the ledger account this line references
     */
    public JournalLine withAccountId(JsonNullable<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    /**
     * Type of the account
     */
    public JournalLine withAccountType(AccountType accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = JsonNullable.of(accountType);
        return this;
    }

    /**
     * Type of the account
     */
    public JournalLine withAccountType(JsonNullable<? extends AccountType> accountType) {
        Utils.checkNotNull(accountType, "accountType");
        this.accountType = accountType;
        return this;
    }

    /**
     * Description of the journal line
     */
    public JournalLine withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    /**
     * Description of the journal line
     */
    public JournalLine withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    /**
     * Currency code for this line
     */
    public JournalLine withCurrencyCode(JournalLineCurrencyCode currencyCode) {
        Utils.checkNotNull(currencyCode, "currencyCode");
        this.currencyCode = JsonNullable.of(currencyCode);
        return this;
    }

    /**
     * Currency code for this line
     */
    public JournalLine withCurrencyCode(JsonNullable<? extends JournalLineCurrencyCode> currencyCode) {
        Utils.checkNotNull(currencyCode, "currencyCode");
        this.currencyCode = currencyCode;
        return this;
    }

    /**
     * Exchange rate to company base currency
     */
    public JournalLine withExchangeRate(double exchangeRate) {
        Utils.checkNotNull(exchangeRate, "exchangeRate");
        this.exchangeRate = JsonNullable.of(exchangeRate);
        return this;
    }

    /**
     * Exchange rate to company base currency
     */
    public JournalLine withExchangeRate(JsonNullable<Double> exchangeRate) {
        Utils.checkNotNull(exchangeRate, "exchangeRate");
        this.exchangeRate = exchangeRate;
        return this;
    }

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative
     * for credit
     */
    public JournalLine withAmount(double amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = JsonNullable.of(amount);
        return this;
    }

    /**
     * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative
     * for credit
     */
    public JournalLine withAmount(JsonNullable<Double> amount) {
        Utils.checkNotNull(amount, "amount");
        this.amount = amount;
        return this;
    }

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    public JournalLine withTaxAmount(double taxAmount) {
        Utils.checkNotNull(taxAmount, "taxAmount");
        this.taxAmount = JsonNullable.of(taxAmount);
        return this;
    }

    /**
     * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
     */
    public JournalLine withTaxAmount(JsonNullable<Double> taxAmount) {
        Utils.checkNotNull(taxAmount, "taxAmount");
        this.taxAmount = taxAmount;
        return this;
    }

    /**
     * Tax rate percentage
     */
    public JournalLine withTaxRatePercentage(double taxRatePercentage) {
        Utils.checkNotNull(taxRatePercentage, "taxRatePercentage");
        this.taxRatePercentage = JsonNullable.of(taxRatePercentage);
        return this;
    }

    /**
     * Tax rate percentage
     */
    public JournalLine withTaxRatePercentage(JsonNullable<Double> taxRatePercentage) {
        Utils.checkNotNull(taxRatePercentage, "taxRatePercentage");
        this.taxRatePercentage = taxRatePercentage;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JournalLine other = (JournalLine) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.accountId, other.accountId) &&
            Utils.enhancedDeepEquals(this.accountType, other.accountType) &&
            Utils.enhancedDeepEquals(this.description, other.description) &&
            Utils.enhancedDeepEquals(this.currencyCode, other.currencyCode) &&
            Utils.enhancedDeepEquals(this.exchangeRate, other.exchangeRate) &&
            Utils.enhancedDeepEquals(this.amount, other.amount) &&
            Utils.enhancedDeepEquals(this.taxAmount, other.taxAmount) &&
            Utils.enhancedDeepEquals(this.taxRatePercentage, other.taxRatePercentage);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, accountId, accountType,
            description, currencyCode, exchangeRate,
            amount, taxAmount, taxRatePercentage);
    }
    
    @Override
    public String toString() {
        return Utils.toString(JournalLine.class,
                "id", id,
                "accountId", accountId,
                "accountType", accountType,
                "description", description,
                "currencyCode", currencyCode,
                "exchangeRate", exchangeRate,
                "amount", amount,
                "taxAmount", taxAmount,
                "taxRatePercentage", taxRatePercentage);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<String> accountId = JsonNullable.undefined();

        private JsonNullable<? extends AccountType> accountType = JsonNullable.undefined();

        private JsonNullable<String> description = JsonNullable.undefined();

        private JsonNullable<? extends JournalLineCurrencyCode> currencyCode = JsonNullable.undefined();

        private JsonNullable<Double> exchangeRate = JsonNullable.undefined();

        private JsonNullable<Double> amount = JsonNullable.undefined();

        private JsonNullable<Double> taxAmount = JsonNullable.undefined();

        private JsonNullable<Double> taxRatePercentage = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Unique identifier for the journal line
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier for the journal line
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * ID of the ledger account this line references
         */
        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = JsonNullable.of(accountId);
            return this;
        }

        /**
         * ID of the ledger account this line references
         */
        public Builder accountId(JsonNullable<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }


        /**
         * Type of the account
         */
        public Builder accountType(AccountType accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = JsonNullable.of(accountType);
            return this;
        }

        /**
         * Type of the account
         */
        public Builder accountType(JsonNullable<? extends AccountType> accountType) {
            Utils.checkNotNull(accountType, "accountType");
            this.accountType = accountType;
            return this;
        }


        /**
         * Description of the journal line
         */
        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        /**
         * Description of the journal line
         */
        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }


        /**
         * Currency code for this line
         */
        public Builder currencyCode(JournalLineCurrencyCode currencyCode) {
            Utils.checkNotNull(currencyCode, "currencyCode");
            this.currencyCode = JsonNullable.of(currencyCode);
            return this;
        }

        /**
         * Currency code for this line
         */
        public Builder currencyCode(JsonNullable<? extends JournalLineCurrencyCode> currencyCode) {
            Utils.checkNotNull(currencyCode, "currencyCode");
            this.currencyCode = currencyCode;
            return this;
        }


        /**
         * Exchange rate to company base currency
         */
        public Builder exchangeRate(double exchangeRate) {
            Utils.checkNotNull(exchangeRate, "exchangeRate");
            this.exchangeRate = JsonNullable.of(exchangeRate);
            return this;
        }

        /**
         * Exchange rate to company base currency
         */
        public Builder exchangeRate(JsonNullable<Double> exchangeRate) {
            Utils.checkNotNull(exchangeRate, "exchangeRate");
            this.exchangeRate = exchangeRate;
            return this;
        }


        /**
         * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative
         * for credit
         */
        public Builder amount(double amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = JsonNullable.of(amount);
            return this;
        }

        /**
         * Amount of the journal line in minor units, e.g. 10010 for 100.10 USD. Positive for debit, negative
         * for credit
         */
        public Builder amount(JsonNullable<Double> amount) {
            Utils.checkNotNull(amount, "amount");
            this.amount = amount;
            return this;
        }


        /**
         * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
         */
        public Builder taxAmount(double taxAmount) {
            Utils.checkNotNull(taxAmount, "taxAmount");
            this.taxAmount = JsonNullable.of(taxAmount);
            return this;
        }

        /**
         * Tax amount of the line in minor units, e.g. 10010 for 100.10 USD
         */
        public Builder taxAmount(JsonNullable<Double> taxAmount) {
            Utils.checkNotNull(taxAmount, "taxAmount");
            this.taxAmount = taxAmount;
            return this;
        }


        /**
         * Tax rate percentage
         */
        public Builder taxRatePercentage(double taxRatePercentage) {
            Utils.checkNotNull(taxRatePercentage, "taxRatePercentage");
            this.taxRatePercentage = JsonNullable.of(taxRatePercentage);
            return this;
        }

        /**
         * Tax rate percentage
         */
        public Builder taxRatePercentage(JsonNullable<Double> taxRatePercentage) {
            Utils.checkNotNull(taxRatePercentage, "taxRatePercentage");
            this.taxRatePercentage = taxRatePercentage;
            return this;
        }

        public JournalLine build() {

            return new JournalLine(
                id, accountId, accountType,
                description, currencyCode, exchangeRate,
                amount, taxAmount, taxRatePercentage);
        }

    }
}
