/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * SkillsLevelValue
 * 
 * <p>The unified skill level. For write operations: provide one of the listed enum values, or omit/set to
 * "unmapped_value" to use source_value instead.
 */
@JsonDeserialize(using = SkillsLevelValue._Deserializer.class)
@JsonSerialize(using = SkillsLevelValue._Serializer.class)
public class SkillsLevelValue {

    public static final SkillsLevelValue PRIMARY = new SkillsLevelValue("primary");
    public static final SkillsLevelValue SECONDARY = new SkillsLevelValue("secondary");
    public static final SkillsLevelValue TERTIARY = new SkillsLevelValue("tertiary");
    public static final SkillsLevelValue UNMAPPED_VALUE = new SkillsLevelValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, SkillsLevelValue> values = createValuesMap();
    private static final Map<String, SkillsLevelValueEnum> enums = createEnumsMap();

    private final String value;

    private SkillsLevelValue(String value) {
        this.value = value;
    }

    /**
     * Returns a SkillsLevelValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as SkillsLevelValue
     */ 
    public static SkillsLevelValue of(String value) {
        synchronized (SkillsLevelValue.class) {
            return values.computeIfAbsent(value, v -> new SkillsLevelValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<SkillsLevelValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SkillsLevelValue other = (SkillsLevelValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "SkillsLevelValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static SkillsLevelValue[] values() {
        synchronized (SkillsLevelValue.class) {
            return values.values().toArray(new SkillsLevelValue[] {});
        }
    }

    private static final Map<String, SkillsLevelValue> createValuesMap() {
        Map<String, SkillsLevelValue> map = new LinkedHashMap<>();
        map.put("primary", PRIMARY);
        map.put("secondary", SECONDARY);
        map.put("tertiary", TERTIARY);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, SkillsLevelValueEnum> createEnumsMap() {
        Map<String, SkillsLevelValueEnum> map = new HashMap<>();
        map.put("primary", SkillsLevelValueEnum.PRIMARY);
        map.put("secondary", SkillsLevelValueEnum.SECONDARY);
        map.put("tertiary", SkillsLevelValueEnum.TERTIARY);
        map.put("unmapped_value", SkillsLevelValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<SkillsLevelValue> {

        protected _Serializer() {
            super(SkillsLevelValue.class);
        }

        @Override
        public void serialize(SkillsLevelValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<SkillsLevelValue> {

        protected _Deserializer() {
            super(SkillsLevelValue.class);
        }

        @Override
        public SkillsLevelValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return SkillsLevelValue.of(v);
        }
    }
    
    public enum SkillsLevelValueEnum {

        PRIMARY("primary"),
        SECONDARY("secondary"),
        TERTIARY("tertiary"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private SkillsLevelValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

