/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.MessagingMessageResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;


public class MessagingGetMessageResponse implements Response {
    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The message was retrieved.
     */
    private Optional<? extends MessagingMessageResult> messagingMessageResult;


    private Map<String, List<String>> headers;

    @JsonCreator
    public MessagingGetMessageResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends MessagingMessageResult> messagingMessageResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(messagingMessageResult, "messagingMessageResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.messagingMessageResult = messagingMessageResult;
        this.headers = headers;
    }
    
    public MessagingGetMessageResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse,
            Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The message was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<MessagingMessageResult> messagingMessageResult() {
        return (Optional<MessagingMessageResult>) messagingMessageResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP response content type for this operation
     */
    public MessagingGetMessageResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public MessagingGetMessageResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public MessagingGetMessageResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The message was retrieved.
     */
    public MessagingGetMessageResponse withMessagingMessageResult(MessagingMessageResult messagingMessageResult) {
        Utils.checkNotNull(messagingMessageResult, "messagingMessageResult");
        this.messagingMessageResult = Optional.ofNullable(messagingMessageResult);
        return this;
    }


    /**
     * The message was retrieved.
     */
    public MessagingGetMessageResponse withMessagingMessageResult(Optional<? extends MessagingMessageResult> messagingMessageResult) {
        Utils.checkNotNull(messagingMessageResult, "messagingMessageResult");
        this.messagingMessageResult = messagingMessageResult;
        return this;
    }

    public MessagingGetMessageResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MessagingGetMessageResponse other = (MessagingGetMessageResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.messagingMessageResult, other.messagingMessageResult) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType, statusCode, rawResponse,
            messagingMessageResult, headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MessagingGetMessageResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "messagingMessageResult", messagingMessageResult,
                "headers", headers);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String contentType;

        private Integer statusCode;

        private HttpResponse<InputStream> rawResponse;

        private Optional<? extends MessagingMessageResult> messagingMessageResult = Optional.empty();

        private Map<String, List<String>> headers;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }


        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }


        /**
         * The message was retrieved.
         */
        public Builder messagingMessageResult(MessagingMessageResult messagingMessageResult) {
            Utils.checkNotNull(messagingMessageResult, "messagingMessageResult");
            this.messagingMessageResult = Optional.ofNullable(messagingMessageResult);
            return this;
        }

        /**
         * The message was retrieved.
         */
        public Builder messagingMessageResult(Optional<? extends MessagingMessageResult> messagingMessageResult) {
            Utils.checkNotNull(messagingMessageResult, "messagingMessageResult");
            this.messagingMessageResult = messagingMessageResult;
            return this;
        }


        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public MessagingGetMessageResponse build() {

            return new MessagingGetMessageResponse(
                contentType, statusCode, rawResponse,
                messagingMessageResult, headers);
        }

    }
}
