/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.OffersResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetOfferResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends OffersResult> offersResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetOfferResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends OffersResult> offersResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(offersResult, "offersResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.offersResult = offersResult;
        this.headers = headers;
    }

    public AtsGetOfferResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OffersResult> offersResult() {
        return this.offersResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetOfferResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetOfferResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetOfferResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetOfferResponse withOffersResult(OffersResult offersResult) {
        Utils.checkNotNull(offersResult, "offersResult");
        this.offersResult = Optional.ofNullable(offersResult);
        return this;
    }

    public AtsGetOfferResponse withOffersResult(Optional<? extends OffersResult> offersResult) {
        Utils.checkNotNull(offersResult, "offersResult");
        this.offersResult = offersResult;
        return this;
    }

    public AtsGetOfferResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetOfferResponse other = (AtsGetOfferResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.offersResult, other.offersResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.offersResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetOfferResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "offersResult", this.offersResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends OffersResult> offersResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder offersResult(OffersResult offersResult) {
            Utils.checkNotNull(offersResult, "offersResult");
            this.offersResult = Optional.ofNullable(offersResult);
            return this;
        }

        public Builder offersResult(Optional<? extends OffersResult> offersResult) {
            Utils.checkNotNull(offersResult, "offersResult");
            this.offersResult = offersResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetOfferResponse build() {
            return new AtsGetOfferResponse(this.contentType, this.statusCode, this.rawResponse, this.offersResult, this.headers);
        }
    }
}

