/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AtsCreateJobRequestDtoValue
 * 
 * <p>The status of the job.
 */
@JsonDeserialize(using = AtsCreateJobRequestDtoValue._Deserializer.class)
@JsonSerialize(using = AtsCreateJobRequestDtoValue._Serializer.class)
public class AtsCreateJobRequestDtoValue {

    public static final AtsCreateJobRequestDtoValue PUBLISHED = new AtsCreateJobRequestDtoValue("published");
    public static final AtsCreateJobRequestDtoValue DRAFT = new AtsCreateJobRequestDtoValue("draft");
    public static final AtsCreateJobRequestDtoValue PENDING = new AtsCreateJobRequestDtoValue("pending");
    public static final AtsCreateJobRequestDtoValue INTERNAL = new AtsCreateJobRequestDtoValue("internal");
    public static final AtsCreateJobRequestDtoValue ARCHIVED = new AtsCreateJobRequestDtoValue("archived");
    public static final AtsCreateJobRequestDtoValue CLOSED = new AtsCreateJobRequestDtoValue("closed");
    public static final AtsCreateJobRequestDtoValue OPEN = new AtsCreateJobRequestDtoValue("open");
    public static final AtsCreateJobRequestDtoValue DELETED = new AtsCreateJobRequestDtoValue("deleted");
    public static final AtsCreateJobRequestDtoValue ON_HOLD = new AtsCreateJobRequestDtoValue("on_hold");
    public static final AtsCreateJobRequestDtoValue UNMAPPED_VALUE = new AtsCreateJobRequestDtoValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AtsCreateJobRequestDtoValue> values = createValuesMap();
    private static final Map<String, AtsCreateJobRequestDtoValueEnum> enums = createEnumsMap();

    private final String value;

    private AtsCreateJobRequestDtoValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AtsCreateJobRequestDtoValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AtsCreateJobRequestDtoValue
     */ 
    public static AtsCreateJobRequestDtoValue of(String value) {
        synchronized (AtsCreateJobRequestDtoValue.class) {
            return values.computeIfAbsent(value, v -> new AtsCreateJobRequestDtoValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AtsCreateJobRequestDtoValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AtsCreateJobRequestDtoValue other = (AtsCreateJobRequestDtoValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AtsCreateJobRequestDtoValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AtsCreateJobRequestDtoValue[] values() {
        synchronized (AtsCreateJobRequestDtoValue.class) {
            return values.values().toArray(new AtsCreateJobRequestDtoValue[] {});
        }
    }

    private static final Map<String, AtsCreateJobRequestDtoValue> createValuesMap() {
        Map<String, AtsCreateJobRequestDtoValue> map = new LinkedHashMap<>();
        map.put("published", PUBLISHED);
        map.put("draft", DRAFT);
        map.put("pending", PENDING);
        map.put("internal", INTERNAL);
        map.put("archived", ARCHIVED);
        map.put("closed", CLOSED);
        map.put("open", OPEN);
        map.put("deleted", DELETED);
        map.put("on_hold", ON_HOLD);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AtsCreateJobRequestDtoValueEnum> createEnumsMap() {
        Map<String, AtsCreateJobRequestDtoValueEnum> map = new HashMap<>();
        map.put("published", AtsCreateJobRequestDtoValueEnum.PUBLISHED);
        map.put("draft", AtsCreateJobRequestDtoValueEnum.DRAFT);
        map.put("pending", AtsCreateJobRequestDtoValueEnum.PENDING);
        map.put("internal", AtsCreateJobRequestDtoValueEnum.INTERNAL);
        map.put("archived", AtsCreateJobRequestDtoValueEnum.ARCHIVED);
        map.put("closed", AtsCreateJobRequestDtoValueEnum.CLOSED);
        map.put("open", AtsCreateJobRequestDtoValueEnum.OPEN);
        map.put("deleted", AtsCreateJobRequestDtoValueEnum.DELETED);
        map.put("on_hold", AtsCreateJobRequestDtoValueEnum.ON_HOLD);
        map.put("unmapped_value", AtsCreateJobRequestDtoValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AtsCreateJobRequestDtoValue> {

        protected _Serializer() {
            super(AtsCreateJobRequestDtoValue.class);
        }

        @Override
        public void serialize(AtsCreateJobRequestDtoValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AtsCreateJobRequestDtoValue> {

        protected _Deserializer() {
            super(AtsCreateJobRequestDtoValue.class);
        }

        @Override
        public AtsCreateJobRequestDtoValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AtsCreateJobRequestDtoValue.of(v);
        }
    }
    
    public enum AtsCreateJobRequestDtoValueEnum {

        PUBLISHED("published"),
        DRAFT("draft"),
        PENDING("pending"),
        INTERNAL("internal"),
        ARCHIVED("archived"),
        CLOSED("closed"),
        OPEN("open"),
        DELETED("deleted"),
        ON_HOLD("on_hold"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AtsCreateJobRequestDtoValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

