/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.utils;

import java.net.http.HttpResponse;
import java.net.http.HttpRequest;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

import com.stackone.stackone_client_java.utils.AsyncHook.AfterError;
import com.stackone.stackone_client_java.utils.AsyncHook.AfterSuccess;
import com.stackone.stackone_client_java.utils.AsyncHook.BeforeRequest;
import com.stackone.stackone_client_java.utils.Hook.AfterErrorContext;
import com.stackone.stackone_client_java.utils.Hook.AfterSuccessContext;
import com.stackone.stackone_client_java.utils.Hook.BeforeRequestContext;
import com.stackone.stackone_client_java.utils.Hooks.FailEarlyException;
import com.stackone.stackone_client_java.utils.Blob;

/**
 * Async hook registry for runtime request/response processing.
 *
 * <p>Example usage:
 * <pre>
 * asyncHooks.registerBeforeRequest((context, request) -&gt;
 *     CompletableFuture.completedFuture(
 *         Helpers.copy(request)
 *             .header("transaction-id", UUID.randomUUID().toString())
 *             .build()));
 * </pre>
 */
// ThreadSafe
public class AsyncHooks implements BeforeRequest, AfterSuccess, AfterError {

    // we use CopyOnWriteArrayList for thread safety
    private final List<BeforeRequest> beforeRequestHooks = new CopyOnWriteArrayList<>();
    private final List<AfterSuccess> afterSuccessHooks = new CopyOnWriteArrayList<>();
    private final List<AfterError> afterErrorHooks = new CopyOnWriteArrayList<>();

    public AsyncHooks() {
    }

    /**
     * Registers an async before-request hook. Hooks are chained in registration order.
     *
     * @param beforeRequest async hook returning {@code CompletableFuture<HttpRequest>}
     * @return this
     */
    public AsyncHooks registerBeforeRequest(BeforeRequest beforeRequest) {
        Utils.checkNotNull(beforeRequest, "beforeRequest");
        this.beforeRequestHooks.add(beforeRequest);
        return this;
    }

    /**
     * Registers an async after-success hook. Hooks are chained in registration order.
     *
     * @param afterSuccess async hook returning {@code CompletableFuture<HttpResponse>}
     * @return this
     */
    public AsyncHooks registerAfterSuccess(AfterSuccess afterSuccess) {
        Utils.checkNotNull(afterSuccess, "afterSuccess");
        this.afterSuccessHooks.add(afterSuccess);
        return this;
    }

    /**
     * Registers an async after-error hook. Hooks are chained in registration order.
     *
     * @param afterError async hook for error handling
     * @return this
     */
    public AsyncHooks registerAfterError(AfterError afterError) {
        Utils.checkNotNull(afterError, "afterError");
        this.afterErrorHooks.add(afterError);
        return this;
    }

    @Override
    public CompletableFuture<HttpRequest> beforeRequest(BeforeRequestContext context, HttpRequest request) {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(request, "request");

        CompletableFuture<HttpRequest> result = CompletableFuture.completedFuture(request);

        for (BeforeRequest hook : beforeRequestHooks) {
            result = result.thenCompose(req -> hook.beforeRequest(context, req));
        }

        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> afterSuccess(
            AfterSuccessContext context,
            HttpResponse<Blob> response) {
        Utils.checkNotNull(context, "context");
        Utils.checkNotNull(response, "response");

        CompletableFuture<HttpResponse<Blob>> result = CompletableFuture.completedFuture(response);

        for (AfterSuccess hook : afterSuccessHooks) {
            result = result.handle((resp, ex) ->
                    hook.afterSuccess(context, resp)
                            .thenApply(hookResp -> {
                                if (hookResp == null) {
                                    throw new IllegalStateException(
                                            "afterSuccess must return a non-null response");
                                }
                                return hookResp;
                            })
            ).thenCompose(future -> future);
        }

        return result;
    }

    @Override
    public CompletableFuture<HttpResponse<Blob>> afterError(
            AfterErrorContext context,
            HttpResponse<Blob> response,
            Throwable error) {
        Utils.checkNotNull(context, "context");
        Utils.checkArgument(
                (response != null) ^ (error != null),
                "one and only one of response or error must be present");

        CompletableFuture<HttpResponse<Blob>> result;
        if (response != null) {
            result = CompletableFuture.completedFuture(response);
        } else {
            result = CompletableFuture.failedFuture(error);
        }

        AtomicBoolean failedEarly = new AtomicBoolean(false);
        for (AfterError hook : afterErrorHooks) {
            result = result.handle((resp, ex) -> {
                        if (failedEarly.get()) {
                            throw (FailEarlyException) ex;
                        }
                        return hook.afterError(context, resp, ex)
                                .handle((hookResp, hookErr) -> {
                                    if (hookErr != null) {
                                        if (hookErr instanceof FailEarlyException) {
                                            failedEarly.set(true);
                                            throw (FailEarlyException) hookErr;
                                        }
                                        throw  Exceptions.unchecked(hookErr);
                                    }
                                    if (hookResp == null) {
                                        throw new IllegalStateException(
                                                "afterError must either throw an exception or return a non-null response");
                                    }

                                    return hookResp;
                                });
                    }
            ).thenCompose(future -> future);
        }

        return result;
    }

}
