/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Deprecated;
import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;


public class LmsCreateAssignmentRequestDto {
    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("external_reference")
    @Deprecated
    private JsonNullable<String> externalReference;

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an
     * integration.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("learning_object_id")
    private JsonNullable<String> learningObjectId;

    /**
     * The progress associated with this assigment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("progress")
    private JsonNullable<Double> progress;

    /**
     * The date the assignment was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The date the assignment is due to be completed
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("due_date")
    private JsonNullable<OffsetDateTime> dueDate;

    /**
     * The status of the assignment
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends LmsCreateAssignmentRequestDtoStatus> status;

    /**
     * The external reference of the learning object associated with this assignment, this is the main
     * identifier for creating assignments.
     */
    @JsonProperty("learning_object_external_reference")
    private String learningObjectExternalReference;

    @JsonCreator
    public LmsCreateAssignmentRequestDto(
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough,
            @JsonProperty("external_reference") JsonNullable<String> externalReference,
            @JsonProperty("learning_object_id") JsonNullable<String> learningObjectId,
            @JsonProperty("progress") JsonNullable<Double> progress,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("due_date") JsonNullable<OffsetDateTime> dueDate,
            @JsonProperty("status") JsonNullable<? extends LmsCreateAssignmentRequestDtoStatus> status,
            @JsonProperty("learning_object_external_reference") String learningObjectExternalReference) {
        Utils.checkNotNull(passthrough, "passthrough");
        Utils.checkNotNull(externalReference, "externalReference");
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        Utils.checkNotNull(progress, "progress");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(dueDate, "dueDate");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.passthrough = passthrough;
        this.externalReference = externalReference;
        this.learningObjectId = learningObjectId;
        this.progress = progress;
        this.createdAt = createdAt;
        this.dueDate = dueDate;
        this.status = status;
        this.learningObjectExternalReference = learningObjectExternalReference;
    }
    
    public LmsCreateAssignmentRequestDto(
            String learningObjectExternalReference) {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), learningObjectExternalReference);
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    @JsonIgnore
    public JsonNullable<String> externalReference() {
        return externalReference;
    }

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an
     * integration.
     */
    @JsonIgnore
    public JsonNullable<String> learningObjectId() {
        return learningObjectId;
    }

    /**
     * The progress associated with this assigment
     */
    @JsonIgnore
    public JsonNullable<Double> progress() {
        return progress;
    }

    /**
     * The date the assignment was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The date the assignment is due to be completed
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> dueDate() {
        return dueDate;
    }

    /**
     * The status of the assignment
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<LmsCreateAssignmentRequestDtoStatus> status() {
        return (JsonNullable<LmsCreateAssignmentRequestDtoStatus>) status;
    }

    /**
     * The external reference of the learning object associated with this assignment, this is the main
     * identifier for creating assignments.
     */
    @JsonIgnore
    public String learningObjectExternalReference() {
        return learningObjectExternalReference;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * Value to pass through to the provider
     */
    public LmsCreateAssignmentRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public LmsCreateAssignmentRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsCreateAssignmentRequestDto withExternalReference(String externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = JsonNullable.of(externalReference);
        return this;
    }

    /**
     * The external reference associated with this assignment
     * 
     * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
     */
    @Deprecated
    public LmsCreateAssignmentRequestDto withExternalReference(JsonNullable<String> externalReference) {
        Utils.checkNotNull(externalReference, "externalReference");
        this.externalReference = externalReference;
        return this;
    }

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an
     * integration.
     */
    public LmsCreateAssignmentRequestDto withLearningObjectId(String learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = JsonNullable.of(learningObjectId);
        return this;
    }

    /**
     * The learning_object_id associated with this assignment. This is not required unless specified in an
     * integration.
     */
    public LmsCreateAssignmentRequestDto withLearningObjectId(JsonNullable<String> learningObjectId) {
        Utils.checkNotNull(learningObjectId, "learningObjectId");
        this.learningObjectId = learningObjectId;
        return this;
    }

    /**
     * The progress associated with this assigment
     */
    public LmsCreateAssignmentRequestDto withProgress(double progress) {
        Utils.checkNotNull(progress, "progress");
        this.progress = JsonNullable.of(progress);
        return this;
    }

    /**
     * The progress associated with this assigment
     */
    public LmsCreateAssignmentRequestDto withProgress(JsonNullable<Double> progress) {
        Utils.checkNotNull(progress, "progress");
        this.progress = progress;
        return this;
    }

    /**
     * The date the assignment was created
     */
    public LmsCreateAssignmentRequestDto withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The date the assignment was created
     */
    public LmsCreateAssignmentRequestDto withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The date the assignment is due to be completed
     */
    public LmsCreateAssignmentRequestDto withDueDate(OffsetDateTime dueDate) {
        Utils.checkNotNull(dueDate, "dueDate");
        this.dueDate = JsonNullable.of(dueDate);
        return this;
    }

    /**
     * The date the assignment is due to be completed
     */
    public LmsCreateAssignmentRequestDto withDueDate(JsonNullable<OffsetDateTime> dueDate) {
        Utils.checkNotNull(dueDate, "dueDate");
        this.dueDate = dueDate;
        return this;
    }

    /**
     * The status of the assignment
     */
    public LmsCreateAssignmentRequestDto withStatus(LmsCreateAssignmentRequestDtoStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    /**
     * The status of the assignment
     */
    public LmsCreateAssignmentRequestDto withStatus(JsonNullable<? extends LmsCreateAssignmentRequestDtoStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The external reference of the learning object associated with this assignment, this is the main
     * identifier for creating assignments.
     */
    public LmsCreateAssignmentRequestDto withLearningObjectExternalReference(String learningObjectExternalReference) {
        Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
        this.learningObjectExternalReference = learningObjectExternalReference;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LmsCreateAssignmentRequestDto other = (LmsCreateAssignmentRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.passthrough, other.passthrough) &&
            Utils.enhancedDeepEquals(this.externalReference, other.externalReference) &&
            Utils.enhancedDeepEquals(this.learningObjectId, other.learningObjectId) &&
            Utils.enhancedDeepEquals(this.progress, other.progress) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.dueDate, other.dueDate) &&
            Utils.enhancedDeepEquals(this.status, other.status) &&
            Utils.enhancedDeepEquals(this.learningObjectExternalReference, other.learningObjectExternalReference);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            passthrough, externalReference, learningObjectId,
            progress, createdAt, dueDate,
            status, learningObjectExternalReference);
    }
    
    @Override
    public String toString() {
        return Utils.toString(LmsCreateAssignmentRequestDto.class,
                "passthrough", passthrough,
                "externalReference", externalReference,
                "learningObjectId", learningObjectId,
                "progress", progress,
                "createdAt", createdAt,
                "dueDate", dueDate,
                "status", status,
                "learningObjectExternalReference", learningObjectExternalReference);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();

        @Deprecated
        private JsonNullable<String> externalReference = JsonNullable.undefined();

        private JsonNullable<String> learningObjectId = JsonNullable.undefined();

        private JsonNullable<Double> progress = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> dueDate = JsonNullable.undefined();

        private JsonNullable<? extends LmsCreateAssignmentRequestDtoStatus> status = JsonNullable.undefined();

        private String learningObjectExternalReference;

        private Builder() {
          // force use of static builder() method
        }


        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }


        /**
         * The external reference associated with this assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalReference(String externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = JsonNullable.of(externalReference);
            return this;
        }

        /**
         * The external reference associated with this assignment
         * 
         * @deprecated field: This will be removed in a future release, please migrate away from it as soon as possible.
         */
        @Deprecated
        public Builder externalReference(JsonNullable<String> externalReference) {
            Utils.checkNotNull(externalReference, "externalReference");
            this.externalReference = externalReference;
            return this;
        }


        /**
         * The learning_object_id associated with this assignment. This is not required unless specified in an
         * integration.
         */
        public Builder learningObjectId(String learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = JsonNullable.of(learningObjectId);
            return this;
        }

        /**
         * The learning_object_id associated with this assignment. This is not required unless specified in an
         * integration.
         */
        public Builder learningObjectId(JsonNullable<String> learningObjectId) {
            Utils.checkNotNull(learningObjectId, "learningObjectId");
            this.learningObjectId = learningObjectId;
            return this;
        }


        /**
         * The progress associated with this assigment
         */
        public Builder progress(double progress) {
            Utils.checkNotNull(progress, "progress");
            this.progress = JsonNullable.of(progress);
            return this;
        }

        /**
         * The progress associated with this assigment
         */
        public Builder progress(JsonNullable<Double> progress) {
            Utils.checkNotNull(progress, "progress");
            this.progress = progress;
            return this;
        }


        /**
         * The date the assignment was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The date the assignment was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The date the assignment is due to be completed
         */
        public Builder dueDate(OffsetDateTime dueDate) {
            Utils.checkNotNull(dueDate, "dueDate");
            this.dueDate = JsonNullable.of(dueDate);
            return this;
        }

        /**
         * The date the assignment is due to be completed
         */
        public Builder dueDate(JsonNullable<OffsetDateTime> dueDate) {
            Utils.checkNotNull(dueDate, "dueDate");
            this.dueDate = dueDate;
            return this;
        }


        /**
         * The status of the assignment
         */
        public Builder status(LmsCreateAssignmentRequestDtoStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        /**
         * The status of the assignment
         */
        public Builder status(JsonNullable<? extends LmsCreateAssignmentRequestDtoStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }


        /**
         * The external reference of the learning object associated with this assignment, this is the main
         * identifier for creating assignments.
         */
        public Builder learningObjectExternalReference(String learningObjectExternalReference) {
            Utils.checkNotNull(learningObjectExternalReference, "learningObjectExternalReference");
            this.learningObjectExternalReference = learningObjectExternalReference;
            return this;
        }

        public LmsCreateAssignmentRequestDto build() {

            return new LmsCreateAssignmentRequestDto(
                passthrough, externalReference, learningObjectId,
                progress, createdAt, dueDate,
                status, learningObjectExternalReference);
        }

    }
}
