/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.HasSecurity;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;

/**
 * SchemeBasic
 */
public class SchemeBasic implements HasSecurity {

    @SpeakeasyMetadata("security:name=username")
    private String username;


    @SpeakeasyMetadata("security:name=password")
    private String password;

    @JsonCreator
    public SchemeBasic(
            String username,
            String password) {
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(password, "password");
        this.username = username;
        this.password = password;
    }

    @JsonIgnore
    public String username() {
        return username;
    }

    @JsonIgnore
    public String password() {
        return password;
    }

    public static Builder builder() {
        return new Builder();
    }


    public SchemeBasic withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    public SchemeBasic withPassword(String password) {
        Utils.checkNotNull(password, "password");
        this.password = password;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchemeBasic other = (SchemeBasic) o;
        return 
            Utils.enhancedDeepEquals(this.username, other.username) &&
            Utils.enhancedDeepEquals(this.password, other.password);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            username, password);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SchemeBasic.class,
                "username", username,
                "password", password);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String username;

        private String password;

        private Builder() {
          // force use of static builder() method
        }


        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }


        public Builder password(String password) {
            Utils.checkNotNull(password, "password");
            this.password = password;
            return this;
        }

        public SchemeBasic build() {

            return new SchemeBasic(
                username, password);
        }

    }
}
