/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class EmployeeEthnicityValue {
    public static final EmployeeEthnicityValue WHITE = new EmployeeEthnicityValue("white");
    public static final EmployeeEthnicityValue BLACK_OR_AFRICAN_AMERICAN = new EmployeeEthnicityValue("black_or_african_american");
    public static final EmployeeEthnicityValue ASIAN = new EmployeeEthnicityValue("asian");
    public static final EmployeeEthnicityValue HISPANIC_OR_LATINO = new EmployeeEthnicityValue("hispanic_or_latino");
    public static final EmployeeEthnicityValue AMERICAN_INDIAN_OR_ALASKA_NATIVE = new EmployeeEthnicityValue("american_indian_or_alaska_native");
    public static final EmployeeEthnicityValue NATIVE_HAWAIIAN_OR_PACIFIC_ISLANDER = new EmployeeEthnicityValue("native_hawaiian_or_pacific_islander");
    public static final EmployeeEthnicityValue TWO_OR_MORE_RACES = new EmployeeEthnicityValue("two_or_more_races");
    public static final EmployeeEthnicityValue NOT_DISCLOSED = new EmployeeEthnicityValue("not_disclosed");
    public static final EmployeeEthnicityValue OTHER = new EmployeeEthnicityValue("other");
    public static final EmployeeEthnicityValue UNMAPPED_VALUE = new EmployeeEthnicityValue("unmapped_value");
    private static final Map<String, EmployeeEthnicityValue> values = EmployeeEthnicityValue.createValuesMap();
    private static final Map<String, EmployeeEthnicityValueEnum> enums = EmployeeEthnicityValue.createEnumsMap();
    private final String value;

    private EmployeeEthnicityValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmployeeEthnicityValue of(String value) {
        Class<EmployeeEthnicityValue> clazz = EmployeeEthnicityValue.class;
        synchronized (EmployeeEthnicityValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmployeeEthnicityValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<EmployeeEthnicityValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmployeeEthnicityValue other = (EmployeeEthnicityValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmployeeEthnicityValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmployeeEthnicityValue[] values() {
        Class<EmployeeEthnicityValue> clazz = EmployeeEthnicityValue.class;
        synchronized (EmployeeEthnicityValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmployeeEthnicityValue[0]);
        }
    }

    private static final Map<String, EmployeeEthnicityValue> createValuesMap() {
        LinkedHashMap<String, EmployeeEthnicityValue> map = new LinkedHashMap<String, EmployeeEthnicityValue>();
        map.put("white", WHITE);
        map.put("black_or_african_american", BLACK_OR_AFRICAN_AMERICAN);
        map.put("asian", ASIAN);
        map.put("hispanic_or_latino", HISPANIC_OR_LATINO);
        map.put("american_indian_or_alaska_native", AMERICAN_INDIAN_OR_ALASKA_NATIVE);
        map.put("native_hawaiian_or_pacific_islander", NATIVE_HAWAIIAN_OR_PACIFIC_ISLANDER);
        map.put("two_or_more_races", TWO_OR_MORE_RACES);
        map.put("not_disclosed", NOT_DISCLOSED);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmployeeEthnicityValueEnum> createEnumsMap() {
        HashMap<String, EmployeeEthnicityValueEnum> map = new HashMap<String, EmployeeEthnicityValueEnum>();
        map.put("white", EmployeeEthnicityValueEnum.WHITE);
        map.put("black_or_african_american", EmployeeEthnicityValueEnum.BLACK_OR_AFRICAN_AMERICAN);
        map.put("asian", EmployeeEthnicityValueEnum.ASIAN);
        map.put("hispanic_or_latino", EmployeeEthnicityValueEnum.HISPANIC_OR_LATINO);
        map.put("american_indian_or_alaska_native", EmployeeEthnicityValueEnum.AMERICAN_INDIAN_OR_ALASKA_NATIVE);
        map.put("native_hawaiian_or_pacific_islander", EmployeeEthnicityValueEnum.NATIVE_HAWAIIAN_OR_PACIFIC_ISLANDER);
        map.put("two_or_more_races", EmployeeEthnicityValueEnum.TWO_OR_MORE_RACES);
        map.put("not_disclosed", EmployeeEthnicityValueEnum.NOT_DISCLOSED);
        map.put("other", EmployeeEthnicityValueEnum.OTHER);
        map.put("unmapped_value", EmployeeEthnicityValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmployeeEthnicityValueEnum {
        WHITE("white"),
        BLACK_OR_AFRICAN_AMERICAN("black_or_african_american"),
        ASIAN("asian"),
        HISPANIC_OR_LATINO("hispanic_or_latino"),
        AMERICAN_INDIAN_OR_ALASKA_NATIVE("american_indian_or_alaska_native"),
        NATIVE_HAWAIIAN_OR_PACIFIC_ISLANDER("native_hawaiian_or_pacific_islander"),
        TWO_OR_MORE_RACES("two_or_more_races"),
        NOT_DISCLOSED("not_disclosed"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmployeeEthnicityValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<EmployeeEthnicityValue> {
        protected _Deserializer() {
            super(EmployeeEthnicityValue.class);
        }

        public EmployeeEthnicityValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return EmployeeEthnicityValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<EmployeeEthnicityValue> {
        protected _Serializer() {
            super(EmployeeEthnicityValue.class);
        }

        public void serialize(EmployeeEthnicityValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

