/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import org.openapitools.jackson.nullable.JsonNullable;


public class ShiftBreak {
    /**
     * The unique identifier of the break
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The start time of the break
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_time")
    private JsonNullable<OffsetDateTime> startTime;

    /**
     * The end time of the break
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_time")
    private JsonNullable<OffsetDateTime> endTime;

    /**
     * The duration of the break in ISO 8601 duration format
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("duration")
    private JsonNullable<String> duration;

    /**
     * Whether the break is paid
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("is_paid")
    private JsonNullable<? extends IsPaid> isPaid;

    /**
     * The date and time the break was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The date and time the break was last updated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    @JsonCreator
    public ShiftBreak(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("start_time") JsonNullable<OffsetDateTime> startTime,
            @JsonProperty("end_time") JsonNullable<OffsetDateTime> endTime,
            @JsonProperty("duration") JsonNullable<String> duration,
            @JsonProperty("is_paid") JsonNullable<? extends IsPaid> isPaid,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(startTime, "startTime");
        Utils.checkNotNull(endTime, "endTime");
        Utils.checkNotNull(duration, "duration");
        Utils.checkNotNull(isPaid, "isPaid");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.isPaid = isPaid;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
    
    public ShiftBreak() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(),
            JsonNullable.undefined());
    }

    /**
     * The unique identifier of the break
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The start time of the break
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> startTime() {
        return startTime;
    }

    /**
     * The end time of the break
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> endTime() {
        return endTime;
    }

    /**
     * The duration of the break in ISO 8601 duration format
     */
    @JsonIgnore
    public JsonNullable<String> duration() {
        return duration;
    }

    /**
     * Whether the break is paid
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IsPaid> isPaid() {
        return (JsonNullable<IsPaid>) isPaid;
    }

    /**
     * The date and time the break was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The date and time the break was last updated
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The unique identifier of the break
     */
    public ShiftBreak withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The unique identifier of the break
     */
    public ShiftBreak withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The start time of the break
     */
    public ShiftBreak withStartTime(OffsetDateTime startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = JsonNullable.of(startTime);
        return this;
    }

    /**
     * The start time of the break
     */
    public ShiftBreak withStartTime(JsonNullable<OffsetDateTime> startTime) {
        Utils.checkNotNull(startTime, "startTime");
        this.startTime = startTime;
        return this;
    }

    /**
     * The end time of the break
     */
    public ShiftBreak withEndTime(OffsetDateTime endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = JsonNullable.of(endTime);
        return this;
    }

    /**
     * The end time of the break
     */
    public ShiftBreak withEndTime(JsonNullable<OffsetDateTime> endTime) {
        Utils.checkNotNull(endTime, "endTime");
        this.endTime = endTime;
        return this;
    }

    /**
     * The duration of the break in ISO 8601 duration format
     */
    public ShiftBreak withDuration(String duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = JsonNullable.of(duration);
        return this;
    }

    /**
     * The duration of the break in ISO 8601 duration format
     */
    public ShiftBreak withDuration(JsonNullable<String> duration) {
        Utils.checkNotNull(duration, "duration");
        this.duration = duration;
        return this;
    }

    /**
     * Whether the break is paid
     */
    public ShiftBreak withIsPaid(IsPaid isPaid) {
        Utils.checkNotNull(isPaid, "isPaid");
        this.isPaid = JsonNullable.of(isPaid);
        return this;
    }

    /**
     * Whether the break is paid
     */
    public ShiftBreak withIsPaid(JsonNullable<? extends IsPaid> isPaid) {
        Utils.checkNotNull(isPaid, "isPaid");
        this.isPaid = isPaid;
        return this;
    }

    /**
     * The date and time the break was created
     */
    public ShiftBreak withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The date and time the break was created
     */
    public ShiftBreak withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The date and time the break was last updated
     */
    public ShiftBreak withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The date and time the break was last updated
     */
    public ShiftBreak withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ShiftBreak other = (ShiftBreak) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.startTime, other.startTime) &&
            Utils.enhancedDeepEquals(this.endTime, other.endTime) &&
            Utils.enhancedDeepEquals(this.duration, other.duration) &&
            Utils.enhancedDeepEquals(this.isPaid, other.isPaid) &&
            Utils.enhancedDeepEquals(this.createdAt, other.createdAt) &&
            Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id, startTime, endTime,
            duration, isPaid, createdAt,
            updatedAt);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ShiftBreak.class,
                "id", id,
                "startTime", startTime,
                "endTime", endTime,
                "duration", duration,
                "isPaid", isPaid,
                "createdAt", createdAt,
                "updatedAt", updatedAt);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> id = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> startTime = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> endTime = JsonNullable.undefined();

        private JsonNullable<String> duration = JsonNullable.undefined();

        private JsonNullable<? extends IsPaid> isPaid = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();

        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The unique identifier of the break
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The unique identifier of the break
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        /**
         * The start time of the break
         */
        public Builder startTime(OffsetDateTime startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = JsonNullable.of(startTime);
            return this;
        }

        /**
         * The start time of the break
         */
        public Builder startTime(JsonNullable<OffsetDateTime> startTime) {
            Utils.checkNotNull(startTime, "startTime");
            this.startTime = startTime;
            return this;
        }


        /**
         * The end time of the break
         */
        public Builder endTime(OffsetDateTime endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = JsonNullable.of(endTime);
            return this;
        }

        /**
         * The end time of the break
         */
        public Builder endTime(JsonNullable<OffsetDateTime> endTime) {
            Utils.checkNotNull(endTime, "endTime");
            this.endTime = endTime;
            return this;
        }


        /**
         * The duration of the break in ISO 8601 duration format
         */
        public Builder duration(String duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = JsonNullable.of(duration);
            return this;
        }

        /**
         * The duration of the break in ISO 8601 duration format
         */
        public Builder duration(JsonNullable<String> duration) {
            Utils.checkNotNull(duration, "duration");
            this.duration = duration;
            return this;
        }


        /**
         * Whether the break is paid
         */
        public Builder isPaid(IsPaid isPaid) {
            Utils.checkNotNull(isPaid, "isPaid");
            this.isPaid = JsonNullable.of(isPaid);
            return this;
        }

        /**
         * Whether the break is paid
         */
        public Builder isPaid(JsonNullable<? extends IsPaid> isPaid) {
            Utils.checkNotNull(isPaid, "isPaid");
            this.isPaid = isPaid;
            return this;
        }


        /**
         * The date and time the break was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The date and time the break was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }


        /**
         * The date and time the break was last updated
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The date and time the break was last updated
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public ShiftBreak build() {

            return new ShiftBreak(
                id, startTime, endTime,
                duration, isPaid, createdAt,
                updatedAt);
        }

    }
}
