/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;


public class AtsDownloadApplicationDocumentRequest {
    /**
     * The account identifier
     */
    @SpeakeasyMetadata("header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=id")
    private String id;


    @SpeakeasyMetadata("pathParam:style=simple,explode=false,name=subResourceId")
    private String subResourceId;

    /**
     * The format to download the file in
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=format")
    private JsonNullable<String> format;

    /**
     * The export format of the file
     */
    @SpeakeasyMetadata("queryParam:style=form,explode=true,name=export_format")
    private JsonNullable<String> exportFormat;

    @JsonCreator
    public AtsDownloadApplicationDocumentRequest(
            String xAccountId,
            String id,
            String subResourceId,
            JsonNullable<String> format,
            JsonNullable<String> exportFormat) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(subResourceId, "subResourceId");
        Utils.checkNotNull(format, "format");
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.xAccountId = xAccountId;
        this.id = id;
        this.subResourceId = subResourceId;
        this.format = format;
        this.exportFormat = exportFormat;
    }
    
    public AtsDownloadApplicationDocumentRequest(
            String xAccountId,
            String id,
            String subResourceId) {
        this(xAccountId, id, subResourceId,
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The account identifier
     */
    @JsonIgnore
    public String xAccountId() {
        return xAccountId;
    }

    @JsonIgnore
    public String id() {
        return id;
    }

    @JsonIgnore
    public String subResourceId() {
        return subResourceId;
    }

    /**
     * The format to download the file in
     */
    @JsonIgnore
    public JsonNullable<String> format() {
        return format;
    }

    /**
     * The export format of the file
     */
    @JsonIgnore
    public JsonNullable<String> exportFormat() {
        return exportFormat;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The account identifier
     */
    public AtsDownloadApplicationDocumentRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsDownloadApplicationDocumentRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsDownloadApplicationDocumentRequest withSubResourceId(String subResourceId) {
        Utils.checkNotNull(subResourceId, "subResourceId");
        this.subResourceId = subResourceId;
        return this;
    }

    /**
     * The format to download the file in
     */
    public AtsDownloadApplicationDocumentRequest withFormat(String format) {
        Utils.checkNotNull(format, "format");
        this.format = JsonNullable.of(format);
        return this;
    }

    /**
     * The format to download the file in
     */
    public AtsDownloadApplicationDocumentRequest withFormat(JsonNullable<String> format) {
        Utils.checkNotNull(format, "format");
        this.format = format;
        return this;
    }

    /**
     * The export format of the file
     */
    public AtsDownloadApplicationDocumentRequest withExportFormat(String exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = JsonNullable.of(exportFormat);
        return this;
    }

    /**
     * The export format of the file
     */
    public AtsDownloadApplicationDocumentRequest withExportFormat(JsonNullable<String> exportFormat) {
        Utils.checkNotNull(exportFormat, "exportFormat");
        this.exportFormat = exportFormat;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsDownloadApplicationDocumentRequest other = (AtsDownloadApplicationDocumentRequest) o;
        return 
            Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) &&
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.subResourceId, other.subResourceId) &&
            Utils.enhancedDeepEquals(this.format, other.format) &&
            Utils.enhancedDeepEquals(this.exportFormat, other.exportFormat);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            xAccountId, id, subResourceId,
            format, exportFormat);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsDownloadApplicationDocumentRequest.class,
                "xAccountId", xAccountId,
                "id", id,
                "subResourceId", subResourceId,
                "format", format,
                "exportFormat", exportFormat);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private String xAccountId;

        private String id;

        private String subResourceId;

        private JsonNullable<String> format = JsonNullable.undefined();

        private JsonNullable<String> exportFormat = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The account identifier
         */
        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }


        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }


        public Builder subResourceId(String subResourceId) {
            Utils.checkNotNull(subResourceId, "subResourceId");
            this.subResourceId = subResourceId;
            return this;
        }


        /**
         * The format to download the file in
         */
        public Builder format(String format) {
            Utils.checkNotNull(format, "format");
            this.format = JsonNullable.of(format);
            return this;
        }

        /**
         * The format to download the file in
         */
        public Builder format(JsonNullable<String> format) {
            Utils.checkNotNull(format, "format");
            this.format = format;
            return this;
        }


        /**
         * The export format of the file
         */
        public Builder exportFormat(String exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = JsonNullable.of(exportFormat);
            return this;
        }

        /**
         * The export format of the file
         */
        public Builder exportFormat(JsonNullable<String> exportFormat) {
            Utils.checkNotNull(exportFormat, "exportFormat");
            this.exportFormat = exportFormat;
            return this;
        }

        public AtsDownloadApplicationDocumentRequest build() {

            return new AtsDownloadApplicationDocumentRequest(
                xAccountId, id, subResourceId,
                format, exportFormat);
        }

    }
}
