/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingTicketCreateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;

public class TicketingCreateTicketRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto;

    @JsonCreator
    public TicketingCreateTicketRequest(String xAccountId, TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(ticketingTicketCreateRequestDto, "ticketingTicketCreateRequestDto");
        this.xAccountId = xAccountId;
        this.ticketingTicketCreateRequestDto = ticketingTicketCreateRequestDto;
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto() {
        return this.ticketingTicketCreateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingCreateTicketRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public TicketingCreateTicketRequest withTicketingTicketCreateRequestDto(TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
        Utils.checkNotNull(ticketingTicketCreateRequestDto, "ticketingTicketCreateRequestDto");
        this.ticketingTicketCreateRequestDto = ticketingTicketCreateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingCreateTicketRequest other = (TicketingCreateTicketRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.ticketingTicketCreateRequestDto, other.ticketingTicketCreateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.ticketingTicketCreateRequestDto);
    }

    public String toString() {
        return Utils.toString(TicketingCreateTicketRequest.class, "xAccountId", this.xAccountId, "ticketingTicketCreateRequestDto", this.ticketingTicketCreateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder ticketingTicketCreateRequestDto(TicketingTicketCreateRequestDto ticketingTicketCreateRequestDto) {
            Utils.checkNotNull(ticketingTicketCreateRequestDto, "ticketingTicketCreateRequestDto");
            this.ticketingTicketCreateRequestDto = ticketingTicketCreateRequestDto;
            return this;
        }

        public TicketingCreateTicketRequest build() {
            return new TicketingCreateTicketRequest(this.xAccountId, this.ticketingTicketCreateRequestDto);
        }
    }
}

