/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Documents;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.models.operations.DocumentsDownloadFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetDriveRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsGetFolderRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListDrivesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFilesRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsListFoldersRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsUploadFileRequest;
import com.stackone.stackone_client_java.models.operations.async.DocumentsDownloadFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsDownloadFileResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetDriveRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetDriveResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFileResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFolderRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsGetFolderResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListDrivesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListDrivesResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFilesRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFilesResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFoldersRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsListFoldersResponse;
import com.stackone.stackone_client_java.models.operations.async.DocumentsUploadFileRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.DocumentsUploadFileResponse;
import com.stackone.stackone_client_java.operations.DocumentsDownloadFile;
import com.stackone.stackone_client_java.operations.DocumentsGetDrive;
import com.stackone.stackone_client_java.operations.DocumentsGetFile;
import com.stackone.stackone_client_java.operations.DocumentsGetFolder;
import com.stackone.stackone_client_java.operations.DocumentsListDrives;
import com.stackone.stackone_client_java.operations.DocumentsListFiles;
import com.stackone.stackone_client_java.operations.DocumentsListFolders;
import com.stackone.stackone_client_java.operations.DocumentsUploadFile;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncDocuments {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Documents syncSDK;

    AsyncDocuments(Documents syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Documents sync() {
        return this.syncSDK;
    }

    public DocumentsDownloadFileRequestBuilder downloadFile() {
        return new DocumentsDownloadFileRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsDownloadFileResponse> downloadFile(DocumentsDownloadFileRequest request) {
        return this.downloadFile(request, Optional.empty());
    }

    public CompletableFuture<DocumentsDownloadFileResponse> downloadFile(DocumentsDownloadFileRequest request, Optional<Options> options) {
        DocumentsDownloadFile.Async operation = new DocumentsDownloadFile.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DocumentsUploadFileRequestBuilder uploadFile() {
        return new DocumentsUploadFileRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsUploadFileResponse> uploadFile(String xAccountId, UnifiedUploadRequestDto unifiedUploadRequestDto) {
        return this.uploadFile(xAccountId, Optional.empty(), Optional.empty(), unifiedUploadRequestDto, Optional.empty());
    }

    public CompletableFuture<DocumentsUploadFileResponse> uploadFile(String xAccountId, Optional<String> xStackoneApiSessionToken, Optional<String> prefer, UnifiedUploadRequestDto unifiedUploadRequestDto, Optional<Options> options) {
        DocumentsUploadFileRequest request = DocumentsUploadFileRequest.builder().xAccountId(xAccountId).xStackoneApiSessionToken(xStackoneApiSessionToken).prefer(prefer).unifiedUploadRequestDto(unifiedUploadRequestDto).build();
        DocumentsUploadFile.Async operation = new DocumentsUploadFile.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DocumentsListFilesRequestBuilder listFiles() {
        return new DocumentsListFilesRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsListFilesResponse> listFiles(DocumentsListFilesRequest request) {
        return this.listFiles(request, Optional.empty());
    }

    public CompletableFuture<DocumentsListFilesResponse> listFiles(DocumentsListFilesRequest request, Optional<Options> options) {
        DocumentsListFiles.Async operation = new DocumentsListFiles.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DocumentsGetFileRequestBuilder getFile() {
        return new DocumentsGetFileRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsGetFileResponse> getFile(DocumentsGetFileRequest request) {
        return this.getFile(request, Optional.empty());
    }

    public CompletableFuture<DocumentsGetFileResponse> getFile(DocumentsGetFileRequest request, Optional<Options> options) {
        DocumentsGetFile.Async operation = new DocumentsGetFile.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DocumentsListFoldersRequestBuilder listFolders() {
        return new DocumentsListFoldersRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsListFoldersResponse> listFolders(DocumentsListFoldersRequest request) {
        return this.listFolders(request, Optional.empty());
    }

    public CompletableFuture<DocumentsListFoldersResponse> listFolders(DocumentsListFoldersRequest request, Optional<Options> options) {
        DocumentsListFolders.Async operation = new DocumentsListFolders.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DocumentsGetFolderRequestBuilder getFolder() {
        return new DocumentsGetFolderRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsGetFolderResponse> getFolder(DocumentsGetFolderRequest request) {
        return this.getFolder(request, Optional.empty());
    }

    public CompletableFuture<DocumentsGetFolderResponse> getFolder(DocumentsGetFolderRequest request, Optional<Options> options) {
        DocumentsGetFolder.Async operation = new DocumentsGetFolder.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DocumentsListDrivesRequestBuilder listDrives() {
        return new DocumentsListDrivesRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsListDrivesResponse> listDrives(DocumentsListDrivesRequest request) {
        return this.listDrives(request, Optional.empty());
    }

    public CompletableFuture<DocumentsListDrivesResponse> listDrives(DocumentsListDrivesRequest request, Optional<Options> options) {
        DocumentsListDrives.Async operation = new DocumentsListDrives.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public DocumentsGetDriveRequestBuilder getDrive() {
        return new DocumentsGetDriveRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<DocumentsGetDriveResponse> getDrive(DocumentsGetDriveRequest request) {
        return this.getDrive(request, Optional.empty());
    }

    public CompletableFuture<DocumentsGetDriveResponse> getDrive(DocumentsGetDriveRequest request, Optional<Options> options) {
        DocumentsGetDrive.Async operation = new DocumentsGetDrive.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

