/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AccountingJournalResultValue {
    public static final AccountingJournalResultValue DRAFT = new AccountingJournalResultValue("draft");
    public static final AccountingJournalResultValue POSTED = new AccountingJournalResultValue("posted");
    public static final AccountingJournalResultValue VOID = new AccountingJournalResultValue("void");
    public static final AccountingJournalResultValue UNMAPPED_VALUE = new AccountingJournalResultValue("unmapped_value");
    private static final Map<String, AccountingJournalResultValue> values = AccountingJournalResultValue.createValuesMap();
    private static final Map<String, AccountingJournalResultValueEnum> enums = AccountingJournalResultValue.createEnumsMap();
    private final String value;

    private AccountingJournalResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static AccountingJournalResultValue of(String value) {
        Class<AccountingJournalResultValue> clazz = AccountingJournalResultValue.class;
        synchronized (AccountingJournalResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AccountingJournalResultValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<AccountingJournalResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountingJournalResultValue other = (AccountingJournalResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AccountingJournalResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AccountingJournalResultValue[] values() {
        Class<AccountingJournalResultValue> clazz = AccountingJournalResultValue.class;
        synchronized (AccountingJournalResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AccountingJournalResultValue[0]);
        }
    }

    private static final Map<String, AccountingJournalResultValue> createValuesMap() {
        LinkedHashMap<String, AccountingJournalResultValue> map = new LinkedHashMap<String, AccountingJournalResultValue>();
        map.put("draft", DRAFT);
        map.put("posted", POSTED);
        map.put("void", VOID);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AccountingJournalResultValueEnum> createEnumsMap() {
        HashMap<String, AccountingJournalResultValueEnum> map = new HashMap<String, AccountingJournalResultValueEnum>();
        map.put("draft", AccountingJournalResultValueEnum.DRAFT);
        map.put("posted", AccountingJournalResultValueEnum.POSTED);
        map.put("void", AccountingJournalResultValueEnum.VOID);
        map.put("unmapped_value", AccountingJournalResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AccountingJournalResultValueEnum {
        DRAFT("draft"),
        POSTED("posted"),
        VOID("void"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AccountingJournalResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

