/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ActionBuildResponseDtoStatus;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class ActionBuildResponseDto {
    @JsonProperty(value="status")
    private ActionBuildResponseDtoStatus status;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="message")
    private Optional<String> message;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="actions_indexed")
    private Optional<Double> actionsIndexed;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="connector_filter")
    private Optional<String> connectorFilter;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="error")
    private Optional<String> error;

    @JsonCreator
    public ActionBuildResponseDto(@JsonProperty(value="status") ActionBuildResponseDtoStatus status, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="actions_indexed") Optional<Double> actionsIndexed, @JsonProperty(value="connector_filter") Optional<String> connectorFilter, @JsonProperty(value="error") Optional<String> error) {
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(actionsIndexed, "actionsIndexed");
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        Utils.checkNotNull(error, "error");
        this.status = status;
        this.message = message;
        this.actionsIndexed = actionsIndexed;
        this.connectorFilter = connectorFilter;
        this.error = error;
    }

    public ActionBuildResponseDto(ActionBuildResponseDtoStatus status) {
        this(status, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public ActionBuildResponseDtoStatus status() {
        return this.status;
    }

    @JsonIgnore
    public Optional<String> message() {
        return this.message;
    }

    @JsonIgnore
    public Optional<Double> actionsIndexed() {
        return this.actionsIndexed;
    }

    @JsonIgnore
    public Optional<String> connectorFilter() {
        return this.connectorFilter;
    }

    @JsonIgnore
    public Optional<String> error() {
        return this.error;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ActionBuildResponseDto withStatus(ActionBuildResponseDtoStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    public ActionBuildResponseDto withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = Optional.ofNullable(message);
        return this;
    }

    public ActionBuildResponseDto withMessage(Optional<String> message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    public ActionBuildResponseDto withActionsIndexed(double actionsIndexed) {
        Utils.checkNotNull(actionsIndexed, "actionsIndexed");
        this.actionsIndexed = Optional.ofNullable(actionsIndexed);
        return this;
    }

    public ActionBuildResponseDto withActionsIndexed(Optional<Double> actionsIndexed) {
        Utils.checkNotNull(actionsIndexed, "actionsIndexed");
        this.actionsIndexed = actionsIndexed;
        return this;
    }

    public ActionBuildResponseDto withConnectorFilter(String connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = Optional.ofNullable(connectorFilter);
        return this;
    }

    public ActionBuildResponseDto withConnectorFilter(Optional<String> connectorFilter) {
        Utils.checkNotNull(connectorFilter, "connectorFilter");
        this.connectorFilter = connectorFilter;
        return this;
    }

    public ActionBuildResponseDto withError(String error) {
        Utils.checkNotNull(error, "error");
        this.error = Optional.ofNullable(error);
        return this;
    }

    public ActionBuildResponseDto withError(Optional<String> error) {
        Utils.checkNotNull(error, "error");
        this.error = error;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionBuildResponseDto other = (ActionBuildResponseDto)o;
        return Utils.enhancedDeepEquals((Object)this.status, (Object)other.status) && Utils.enhancedDeepEquals(this.message, other.message) && Utils.enhancedDeepEquals(this.actionsIndexed, other.actionsIndexed) && Utils.enhancedDeepEquals(this.connectorFilter, other.connectorFilter) && Utils.enhancedDeepEquals(this.error, other.error);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.status, this.message, this.actionsIndexed, this.connectorFilter, this.error});
    }

    public String toString() {
        return Utils.toString(ActionBuildResponseDto.class, new Object[]{"status", this.status, "message", this.message, "actionsIndexed", this.actionsIndexed, "connectorFilter", this.connectorFilter, "error", this.error});
    }

    public static final class Builder {
        private ActionBuildResponseDtoStatus status;
        private Optional<String> message = Optional.empty();
        private Optional<Double> actionsIndexed = Optional.empty();
        private Optional<String> connectorFilter = Optional.empty();
        private Optional<String> error = Optional.empty();

        private Builder() {
        }

        public Builder status(ActionBuildResponseDtoStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = Optional.ofNullable(message);
            return this;
        }

        public Builder message(Optional<String> message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        public Builder actionsIndexed(double actionsIndexed) {
            Utils.checkNotNull(actionsIndexed, "actionsIndexed");
            this.actionsIndexed = Optional.ofNullable(actionsIndexed);
            return this;
        }

        public Builder actionsIndexed(Optional<Double> actionsIndexed) {
            Utils.checkNotNull(actionsIndexed, "actionsIndexed");
            this.actionsIndexed = actionsIndexed;
            return this;
        }

        public Builder connectorFilter(String connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = Optional.ofNullable(connectorFilter);
            return this;
        }

        public Builder connectorFilter(Optional<String> connectorFilter) {
            Utils.checkNotNull(connectorFilter, "connectorFilter");
            this.connectorFilter = connectorFilter;
            return this;
        }

        public Builder error(String error) {
            Utils.checkNotNull(error, "error");
            this.error = Optional.ofNullable(error);
            return this;
        }

        public Builder error(Optional<String> error) {
            Utils.checkNotNull(error, "error");
            this.error = error;
            return this;
        }

        public ActionBuildResponseDto build() {
            return new ActionBuildResponseDto(this.status, this.message, this.actionsIndexed, this.connectorFilter, this.error);
        }
    }
}

