/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AnswerValue {
    public static final AnswerValue SHORT_TEXT = new AnswerValue("short_text");
    public static final AnswerValue LONG_TEXT = new AnswerValue("long_text");
    public static final AnswerValue ATTACHMENT = new AnswerValue("attachment");
    public static final AnswerValue MULTI_SELECT = new AnswerValue("multi_select");
    public static final AnswerValue SINGLE_SELECT = new AnswerValue("single_select");
    public static final AnswerValue BOOLEAN = new AnswerValue("boolean");
    public static final AnswerValue NUMBER = new AnswerValue("number");
    public static final AnswerValue DATE = new AnswerValue("date");
    public static final AnswerValue VIDEO = new AnswerValue("video");
    public static final AnswerValue REFERENCE_CHECK = new AnswerValue("reference_check");
    public static final AnswerValue URL = new AnswerValue("url");
    public static final AnswerValue UNMAPPED_VALUE = new AnswerValue("unmapped_value");
    private static final Map<String, AnswerValue> values = AnswerValue.createValuesMap();
    private static final Map<String, AnswerValueEnum> enums = AnswerValue.createEnumsMap();
    private final String value;

    private AnswerValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static AnswerValue of(String value) {
        Class<AnswerValue> clazz = AnswerValue.class;
        synchronized (AnswerValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AnswerValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<AnswerValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnswerValue other = (AnswerValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AnswerValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnswerValue[] values() {
        Class<AnswerValue> clazz = AnswerValue.class;
        synchronized (AnswerValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AnswerValue[0]);
        }
    }

    private static final Map<String, AnswerValue> createValuesMap() {
        LinkedHashMap<String, AnswerValue> map = new LinkedHashMap<String, AnswerValue>();
        map.put("short_text", SHORT_TEXT);
        map.put("long_text", LONG_TEXT);
        map.put("attachment", ATTACHMENT);
        map.put("multi_select", MULTI_SELECT);
        map.put("single_select", SINGLE_SELECT);
        map.put("boolean", BOOLEAN);
        map.put("number", NUMBER);
        map.put("date", DATE);
        map.put("video", VIDEO);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("url", URL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AnswerValueEnum> createEnumsMap() {
        HashMap<String, AnswerValueEnum> map = new HashMap<String, AnswerValueEnum>();
        map.put("short_text", AnswerValueEnum.SHORT_TEXT);
        map.put("long_text", AnswerValueEnum.LONG_TEXT);
        map.put("attachment", AnswerValueEnum.ATTACHMENT);
        map.put("multi_select", AnswerValueEnum.MULTI_SELECT);
        map.put("single_select", AnswerValueEnum.SINGLE_SELECT);
        map.put("boolean", AnswerValueEnum.BOOLEAN);
        map.put("number", AnswerValueEnum.NUMBER);
        map.put("date", AnswerValueEnum.DATE);
        map.put("video", AnswerValueEnum.VIDEO);
        map.put("reference_check", AnswerValueEnum.REFERENCE_CHECK);
        map.put("url", AnswerValueEnum.URL);
        map.put("unmapped_value", AnswerValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AnswerValueEnum {
        SHORT_TEXT("short_text"),
        LONG_TEXT("long_text"),
        ATTACHMENT("attachment"),
        MULTI_SELECT("multi_select"),
        SINGLE_SELECT("single_select"),
        BOOLEAN("boolean"),
        NUMBER("number"),
        DATE("date"),
        VIDEO("video"),
        REFERENCE_CHECK("reference_check"),
        URL("url"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AnswerValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

