/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ApplicationAttachmentValue {
    public static final ApplicationAttachmentValue TEXT = new ApplicationAttachmentValue("text");
    public static final ApplicationAttachmentValue PDF = new ApplicationAttachmentValue("pdf");
    public static final ApplicationAttachmentValue VIDEO = new ApplicationAttachmentValue("video");
    public static final ApplicationAttachmentValue OTHER = new ApplicationAttachmentValue("other");
    public static final ApplicationAttachmentValue UNMAPPED_VALUE = new ApplicationAttachmentValue("unmapped_value");
    private static final Map<String, ApplicationAttachmentValue> values = ApplicationAttachmentValue.createValuesMap();
    private static final Map<String, ApplicationAttachmentValueEnum> enums = ApplicationAttachmentValue.createEnumsMap();
    private final String value;

    private ApplicationAttachmentValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static ApplicationAttachmentValue of(String value) {
        Class<ApplicationAttachmentValue> clazz = ApplicationAttachmentValue.class;
        synchronized (ApplicationAttachmentValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ApplicationAttachmentValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<ApplicationAttachmentValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationAttachmentValue other = (ApplicationAttachmentValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ApplicationAttachmentValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationAttachmentValue[] values() {
        Class<ApplicationAttachmentValue> clazz = ApplicationAttachmentValue.class;
        synchronized (ApplicationAttachmentValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ApplicationAttachmentValue[0]);
        }
    }

    private static final Map<String, ApplicationAttachmentValue> createValuesMap() {
        LinkedHashMap<String, ApplicationAttachmentValue> map = new LinkedHashMap<String, ApplicationAttachmentValue>();
        map.put("text", TEXT);
        map.put("pdf", PDF);
        map.put("video", VIDEO);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationAttachmentValueEnum> createEnumsMap() {
        HashMap<String, ApplicationAttachmentValueEnum> map = new HashMap<String, ApplicationAttachmentValueEnum>();
        map.put("text", ApplicationAttachmentValueEnum.TEXT);
        map.put("pdf", ApplicationAttachmentValueEnum.PDF);
        map.put("video", ApplicationAttachmentValueEnum.VIDEO);
        map.put("other", ApplicationAttachmentValueEnum.OTHER);
        map.put("unmapped_value", ApplicationAttachmentValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ApplicationAttachmentValueEnum {
        TEXT("text"),
        PDF("pdf"),
        VIDEO("video"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ApplicationAttachmentValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

