/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ApplicationValue {
    public static final ApplicationValue ACTIVE = new ApplicationValue("active");
    public static final ApplicationValue ASSESSMENT = new ApplicationValue("assessment");
    public static final ApplicationValue BACKGROUND_CHECK = new ApplicationValue("background_check");
    public static final ApplicationValue CONVERTED = new ApplicationValue("converted");
    public static final ApplicationValue DECLINED_BY_CANDIDATE = new ApplicationValue("declined_by_candidate");
    public static final ApplicationValue HIRED = new ApplicationValue("hired");
    public static final ApplicationValue INTERVIEW = new ApplicationValue("interview");
    public static final ApplicationValue LEAD = new ApplicationValue("lead");
    public static final ApplicationValue OFFER = new ApplicationValue("offer");
    public static final ApplicationValue REFERENCE_CHECK = new ApplicationValue("reference_check");
    public static final ApplicationValue REJECTED = new ApplicationValue("rejected");
    public static final ApplicationValue REVIEW = new ApplicationValue("review");
    public static final ApplicationValue SCREEN = new ApplicationValue("screen");
    public static final ApplicationValue NEW = new ApplicationValue("new");
    public static final ApplicationValue ONBOARDING = new ApplicationValue("onboarding");
    public static final ApplicationValue CREATED = new ApplicationValue("created");
    public static final ApplicationValue ACCEPTED = new ApplicationValue("accepted");
    public static final ApplicationValue SHORT_LIST = new ApplicationValue("short_list");
    public static final ApplicationValue APPROVED = new ApplicationValue("approved");
    public static final ApplicationValue UNMAPPED_VALUE = new ApplicationValue("unmapped_value");
    private static final Map<String, ApplicationValue> values = ApplicationValue.createValuesMap();
    private static final Map<String, ApplicationValueEnum> enums = ApplicationValue.createEnumsMap();
    private final String value;

    private ApplicationValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static ApplicationValue of(String value) {
        Class<ApplicationValue> clazz = ApplicationValue.class;
        synchronized (ApplicationValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new ApplicationValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<ApplicationValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationValue other = (ApplicationValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "ApplicationValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationValue[] values() {
        Class<ApplicationValue> clazz = ApplicationValue.class;
        synchronized (ApplicationValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new ApplicationValue[0]);
        }
    }

    private static final Map<String, ApplicationValue> createValuesMap() {
        LinkedHashMap<String, ApplicationValue> map = new LinkedHashMap<String, ApplicationValue>();
        map.put("active", ACTIVE);
        map.put("assessment", ASSESSMENT);
        map.put("background_check", BACKGROUND_CHECK);
        map.put("converted", CONVERTED);
        map.put("declined_by_candidate", DECLINED_BY_CANDIDATE);
        map.put("hired", HIRED);
        map.put("interview", INTERVIEW);
        map.put("lead", LEAD);
        map.put("offer", OFFER);
        map.put("reference_check", REFERENCE_CHECK);
        map.put("rejected", REJECTED);
        map.put("review", REVIEW);
        map.put("screen", SCREEN);
        map.put("new", NEW);
        map.put("onboarding", ONBOARDING);
        map.put("created", CREATED);
        map.put("accepted", ACCEPTED);
        map.put("short_list", SHORT_LIST);
        map.put("approved", APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, ApplicationValueEnum> createEnumsMap() {
        HashMap<String, ApplicationValueEnum> map = new HashMap<String, ApplicationValueEnum>();
        map.put("active", ApplicationValueEnum.ACTIVE);
        map.put("assessment", ApplicationValueEnum.ASSESSMENT);
        map.put("background_check", ApplicationValueEnum.BACKGROUND_CHECK);
        map.put("converted", ApplicationValueEnum.CONVERTED);
        map.put("declined_by_candidate", ApplicationValueEnum.DECLINED_BY_CANDIDATE);
        map.put("hired", ApplicationValueEnum.HIRED);
        map.put("interview", ApplicationValueEnum.INTERVIEW);
        map.put("lead", ApplicationValueEnum.LEAD);
        map.put("offer", ApplicationValueEnum.OFFER);
        map.put("reference_check", ApplicationValueEnum.REFERENCE_CHECK);
        map.put("rejected", ApplicationValueEnum.REJECTED);
        map.put("review", ApplicationValueEnum.REVIEW);
        map.put("screen", ApplicationValueEnum.SCREEN);
        map.put("new", ApplicationValueEnum.NEW);
        map.put("onboarding", ApplicationValueEnum.ONBOARDING);
        map.put("created", ApplicationValueEnum.CREATED);
        map.put("accepted", ApplicationValueEnum.ACCEPTED);
        map.put("short_list", ApplicationValueEnum.SHORT_LIST);
        map.put("approved", ApplicationValueEnum.APPROVED);
        map.put("unmapped_value", ApplicationValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum ApplicationValueEnum {
        ACTIVE("active"),
        ASSESSMENT("assessment"),
        BACKGROUND_CHECK("background_check"),
        CONVERTED("converted"),
        DECLINED_BY_CANDIDATE("declined_by_candidate"),
        HIRED("hired"),
        INTERVIEW("interview"),
        LEAD("lead"),
        OFFER("offer"),
        REFERENCE_CHECK("reference_check"),
        REJECTED("rejected"),
        REVIEW("review"),
        SCREEN("screen"),
        NEW("new"),
        ONBOARDING("onboarding"),
        CREATED("created"),
        ACCEPTED("accepted"),
        SHORT_LIST("short_list"),
        APPROVED("approved"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private ApplicationValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

